/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.math.structures.groups.debug;

import java.math.BigInteger;
import java.util.Objects;
import org.cryptimeleon.math.serialization.Representation;
import org.cryptimeleon.math.serialization.annotations.ReprUtil;
import org.cryptimeleon.math.serialization.annotations.Represented;
import org.cryptimeleon.math.structures.groups.Group;
import org.cryptimeleon.math.structures.groups.GroupElement;
import org.cryptimeleon.math.structures.groups.debug.DebugBilinearMapImpl;
import org.cryptimeleon.math.structures.groups.debug.DebugGroup;
import org.cryptimeleon.math.structures.groups.debug.DebugGroupElement;
import org.cryptimeleon.math.structures.groups.elliptic.BilinearMap;
import org.cryptimeleon.math.structures.groups.lazy.LazyBilinearMap;
import org.cryptimeleon.math.structures.groups.lazy.LazyGroup;
import org.cryptimeleon.math.structures.groups.lazy.LazyGroupElement;

public class DebugBilinearMap
implements BilinearMap {
    @Represented
    LazyBilinearMap totalBilMap;
    @Represented
    LazyBilinearMap expMultiExpBilMap;

    public DebugBilinearMap(LazyBilinearMap totalBilMap, LazyBilinearMap expMultiExpBilMap) {
        this.totalBilMap = totalBilMap;
        this.expMultiExpBilMap = expMultiExpBilMap;
    }

    public DebugBilinearMap(Representation repr) {
        ReprUtil.deserialize(this, repr);
    }

    @Override
    public Group getG1() {
        return new DebugGroup((LazyGroup)this.totalBilMap.getG1(), (LazyGroup)this.expMultiExpBilMap.getG1());
    }

    @Override
    public Group getG2() {
        return new DebugGroup((LazyGroup)this.totalBilMap.getG2(), (LazyGroup)this.expMultiExpBilMap.getG2());
    }

    @Override
    public Group getGT() {
        return new DebugGroup((LazyGroup)this.totalBilMap.getGT(), (LazyGroup)this.expMultiExpBilMap.getGT());
    }

    @Override
    public GroupElement apply(GroupElement g1, GroupElement g2, BigInteger exponent) {
        DebugGroupElement g1Cast = (DebugGroupElement)g1;
        DebugGroupElement g2Cast = (DebugGroupElement)g2;
        LazyGroupElement g1Result = (LazyGroupElement)this.totalBilMap.apply((GroupElement)g1Cast.elemTotal, (GroupElement)g2Cast.elemTotal, exponent);
        LazyGroupElement g2Result = (LazyGroupElement)this.expMultiExpBilMap.apply((GroupElement)g1Cast.elemExpMultiExp, (GroupElement)g2Cast.elemExpMultiExp, exponent);
        return new DebugGroupElement((DebugGroup)this.getGT(), g1Result, g2Result);
    }

    @Override
    public GroupElement apply(GroupElement g1, GroupElement g2) {
        DebugGroupElement g1Cast = (DebugGroupElement)g1;
        DebugGroupElement g2Cast = (DebugGroupElement)g2;
        LazyGroupElement g1Result = (LazyGroupElement)this.totalBilMap.apply(g1Cast.elemTotal, g2Cast.elemTotal);
        LazyGroupElement g2Result = (LazyGroupElement)this.expMultiExpBilMap.apply(g1Cast.elemExpMultiExp, g2Cast.elemExpMultiExp);
        return new DebugGroupElement((DebugGroup)this.getGT(), g1Result, g2Result);
    }

    @Override
    public boolean isSymmetric() {
        return this.totalBilMap.isSymmetric() && this.expMultiExpBilMap.isSymmetric();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        DebugBilinearMap that = (DebugBilinearMap)other;
        return Objects.equals(this.totalBilMap, that.totalBilMap) && Objects.equals(this.expMultiExpBilMap, that.expMultiExpBilMap);
    }

    public int hashCode() {
        return Objects.hash(this.totalBilMap, this.expMultiExpBilMap);
    }

    public long getNumPairings() {
        return ((DebugBilinearMapImpl)this.totalBilMap.getImpl()).getNumPairings();
    }

    public void resetNumPairings() {
        ((DebugBilinearMapImpl)this.totalBilMap.getImpl()).resetNumPairings();
        ((DebugBilinearMapImpl)this.expMultiExpBilMap.getImpl()).resetNumPairings();
    }

    public String toString() {
        if (this.isSymmetric()) {
            return "Symmetric " + this.getClass().getSimpleName() + "(" + this.totalBilMap + ";" + this.expMultiExpBilMap + ")";
        }
        return "Asymmetric " + this.getClass().getSimpleName() + "(" + this.totalBilMap + ";" + this.expMultiExpBilMap + ")";
    }

    public String formatCounterData() {
        return "---------- Operation data for " + this.toString() + "----------\n" + ((DebugGroup)this.getG1()).formatCounterData() + (this.isSymmetric() ? "" : ((DebugGroup)this.getG2()).formatCounterData()) + ((DebugGroup)this.getGT()).formatCounterData() + "------- Number of pairings: " + this.getNumPairings() + " -------";
    }
}

