/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.math.structures.groups.debug;

import java.util.Objects;
import org.cryptimeleon.math.serialization.Representation;
import org.cryptimeleon.math.serialization.annotations.ReprUtil;
import org.cryptimeleon.math.serialization.annotations.Represented;
import org.cryptimeleon.math.structures.groups.GroupElementImpl;
import org.cryptimeleon.math.structures.groups.debug.DebugGroupElementImpl;
import org.cryptimeleon.math.structures.groups.debug.DebugGroupImpl;
import org.cryptimeleon.math.structures.groups.mappings.impl.GroupHomomorphismImpl;

public class DebugIsomorphismImpl
implements GroupHomomorphismImpl {
    @Represented
    private DebugGroupImpl src;
    @Represented
    private DebugGroupImpl target;

    public DebugIsomorphismImpl(DebugGroupImpl src, DebugGroupImpl target) {
        this.src = src;
        this.target = target;
    }

    public DebugIsomorphismImpl(Representation repr) {
        new ReprUtil(this).deserialize(repr);
    }

    @Override
    public Representation getRepresentation() {
        return ReprUtil.serialize(this);
    }

    @Override
    public GroupElementImpl apply(GroupElementImpl groupElement) {
        if (!groupElement.getStructure().equals(this.src)) {
            throw new IllegalArgumentException("Tried to apply isomorphism on wrong group (argument was from " + groupElement.getStructure() + ")");
        }
        return new DebugGroupElementImpl(this.target, ((DebugGroupElementImpl)groupElement).elem);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DebugIsomorphismImpl that = (DebugIsomorphismImpl)o;
        return Objects.equals(this.src, that.src) && Objects.equals(this.target, that.target);
    }

    public int hashCode() {
        return Objects.hash(this.src, this.target);
    }
}

