/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.math.structures.groups.elliptic.nopairing;

import java.math.BigInteger;
import java.util.Objects;
import java.util.Optional;
import org.cryptimeleon.math.random.RandomGenerator;
import org.cryptimeleon.math.serialization.RepresentableRepresentation;
import org.cryptimeleon.math.serialization.Representation;
import org.cryptimeleon.math.serialization.StringRepresentation;
import org.cryptimeleon.math.structures.groups.GroupElementImpl;
import org.cryptimeleon.math.structures.groups.elliptic.AffineEllipticCurvePoint;
import org.cryptimeleon.math.structures.groups.elliptic.EllipticCurvePoint;
import org.cryptimeleon.math.structures.groups.elliptic.WeierstrassCurve;
import org.cryptimeleon.math.structures.groups.mappings.impl.HashIntoGroupImpl;
import org.cryptimeleon.math.structures.rings.Field;
import org.cryptimeleon.math.structures.rings.FieldElement;
import org.cryptimeleon.math.structures.rings.zn.HashIntoZp;
import org.cryptimeleon.math.structures.rings.zn.Zp;

public class Secp256k1
implements WeierstrassCurve {
    public static final BigInteger p = new BigInteger("FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFFFFFC2F", 16);
    public static final BigInteger n = new BigInteger("FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEBAAEDCE6AF48A03BBFD25E8CD0364141", 16);
    public static final Zp zp = new Zp(p);
    public static final Zp.ZpElement b = zp.valueOf(7L);
    public static final Zp.ZpElement generatorX = zp.valueOf(new BigInteger("79BE667EF9DCBBAC55A06295CE870B07029BFCDB2DCE28D959F2815B16F81798", 16));
    public static final Zp.ZpElement generatorY = zp.valueOf(new BigInteger("483ADA7726A3C4655DA4FBFC0E1108A8FD17B448A68554199C47D08FFB10D4B8", 16));

    public Secp256k1() {
    }

    public Secp256k1(Representation repr) {
        this();
    }

    @Override
    public FieldElement getA6() {
        return b;
    }

    @Override
    public FieldElement getA4() {
        return zp.getZeroElement();
    }

    @Override
    public FieldElement getA3() {
        return zp.getZeroElement();
    }

    @Override
    public FieldElement getA2() {
        return zp.getZeroElement();
    }

    @Override
    public FieldElement getA1() {
        return zp.getZeroElement();
    }

    @Override
    public EllipticCurvePoint getElement(FieldElement x, FieldElement y) {
        return new AffineEllipticCurvePoint(this, x, y);
    }

    @Override
    public Field getFieldOfDefinition() {
        return zp;
    }

    @Override
    public GroupElementImpl getNeutralElement() {
        return new AffineEllipticCurvePoint(this);
    }

    @Override
    public GroupElementImpl getUniformlyRandomElement() throws UnsupportedOperationException {
        return this.getGenerator().pow(RandomGenerator.getRandomNumber(n));
    }

    @Override
    public GroupElementImpl restoreElement(Representation repr) {
        return new AffineEllipticCurvePoint(this, repr);
    }

    @Override
    public GroupElementImpl getGenerator() throws UnsupportedOperationException {
        return this.getElement(generatorX, generatorY);
    }

    @Override
    public BigInteger size() throws UnsupportedOperationException {
        return n;
    }

    @Override
    public boolean hasPrimeSize() {
        return true;
    }

    @Override
    public double estimateCostInvPerOp() {
        return 346.0;
    }

    @Override
    public Optional<Integer> getUniqueByteLength() {
        return Optional.empty();
    }

    @Override
    public Representation getRepresentation() {
        return new StringRepresentation("secp256k1");
    }

    public boolean equals(Object obj) {
        return obj instanceof Secp256k1;
    }

    public int hashCode() {
        return 0;
    }

    public static class HashIntoSecp256k1
    implements HashIntoGroupImpl {
        private final HashIntoZp hash;

        public HashIntoSecp256k1(HashIntoZp hash) {
            this.hash = hash;
            if (!hash.getTargetStructure().equals(zp)) {
                throw new IllegalStateException("Hash must be into Z" + p);
            }
        }

        public HashIntoSecp256k1() {
            this(new HashIntoZp(zp));
        }

        public HashIntoSecp256k1(Representation repr) {
            this.hash = (HashIntoZp)repr.repr().recreateRepresentable();
        }

        @Override
        public Representation getRepresentation() {
            return new RepresentableRepresentation(this.hash);
        }

        @Override
        public GroupElementImpl hashIntoGroupImpl(byte[] x) {
            Zp.ZpElement xCoordinate = this.hash.hash(x);
            Zp.ZpElement ySquared;
            while (!(ySquared = xCoordinate.pow(3L).add(b)).isSquare()) {
                xCoordinate = xCoordinate.add(zp.getOneElement());
            }
            return new Secp256k1().getElement(xCoordinate, ySquared.sqrt());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            HashIntoSecp256k1 that = (HashIntoSecp256k1)o;
            return this.hash.equals(that.hash);
        }

        public int hashCode() {
            return Objects.hash(this.hash);
        }
    }
}

