/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.math.structures.groups.lazy;

import java.util.Objects;
import org.cryptimeleon.math.serialization.Representation;
import org.cryptimeleon.math.serialization.annotations.ReprUtil;
import org.cryptimeleon.math.serialization.annotations.Represented;
import org.cryptimeleon.math.structures.groups.elliptic.BilinearGroup;
import org.cryptimeleon.math.structures.groups.elliptic.BilinearGroupImpl;
import org.cryptimeleon.math.structures.groups.lazy.HashIntoLazyGroup;
import org.cryptimeleon.math.structures.groups.lazy.LazyBilinearMap;
import org.cryptimeleon.math.structures.groups.lazy.LazyGroup;
import org.cryptimeleon.math.structures.groups.lazy.LazyGroupHomomorphism;

public class LazyBilinearGroup
implements BilinearGroup {
    @Represented
    protected BilinearGroupImpl impl;
    LazyGroup g1;
    LazyGroup g2;
    LazyGroup gt;
    LazyGroupHomomorphism homG2toG1;
    LazyBilinearMap map;
    HashIntoLazyGroup hashIntoG1;
    HashIntoLazyGroup hashIntoG2;
    HashIntoLazyGroup hashIntoGt;

    public LazyBilinearGroup(BilinearGroupImpl impl) {
        this.impl = impl;
        this.instantiateBasicStuff();
    }

    public LazyBilinearGroup(Representation repr) {
        ReprUtil.deserialize(this, repr);
        this.instantiateBasicStuff();
    }

    protected void instantiateBasicStuff() {
        this.g1 = new LazyGroup(this.impl.getG1());
        this.g2 = new LazyGroup(this.impl.getG2());
        this.gt = new LazyGroup(this.impl.getGT());
        this.map = new LazyBilinearMap(this.g1, this.g2, this.gt, this.impl.getBilinearMap());
        try {
            this.homG2toG1 = new LazyGroupHomomorphism(this.g1, this.impl.getHomomorphismG2toG1());
        }
        catch (UnsupportedOperationException e) {
            this.homG2toG1 = null;
        }
        try {
            this.hashIntoG1 = new HashIntoLazyGroup(this.impl.getHashIntoG1(), this.g1);
        }
        catch (UnsupportedOperationException e) {
            this.hashIntoG1 = null;
        }
        try {
            this.hashIntoG2 = new HashIntoLazyGroup(this.impl.getHashIntoG2(), this.g2);
        }
        catch (UnsupportedOperationException e) {
            this.hashIntoG2 = null;
        }
        try {
            this.hashIntoGt = new HashIntoLazyGroup(this.impl.getHashIntoGT(), this.gt);
        }
        catch (UnsupportedOperationException e) {
            this.hashIntoGt = null;
        }
    }

    @Override
    public LazyGroup getG1() {
        return this.g1;
    }

    @Override
    public LazyGroup getG2() {
        return this.g2;
    }

    @Override
    public LazyGroup getGT() {
        return this.gt;
    }

    @Override
    public LazyBilinearMap getBilinearMap() {
        return this.map;
    }

    @Override
    public LazyGroupHomomorphism getHomomorphismG2toG1() throws UnsupportedOperationException {
        if (this.homG2toG1 == null) {
            throw new UnsupportedOperationException("No homomorphism available");
        }
        return this.homG2toG1;
    }

    @Override
    public HashIntoLazyGroup getHashIntoG1() throws UnsupportedOperationException {
        if (this.hashIntoG1 == null) {
            throw new UnsupportedOperationException("No hash available");
        }
        return this.hashIntoG1;
    }

    @Override
    public HashIntoLazyGroup getHashIntoG2() throws UnsupportedOperationException {
        if (this.hashIntoG2 == null) {
            throw new UnsupportedOperationException("No hash available");
        }
        return this.hashIntoG2;
    }

    @Override
    public HashIntoLazyGroup getHashIntoGT() throws UnsupportedOperationException {
        if (this.hashIntoGt == null) {
            throw new UnsupportedOperationException("No hash available");
        }
        return this.hashIntoGt;
    }

    @Override
    public Integer getSecurityLevel() {
        return this.impl.getSecurityLevel();
    }

    @Override
    public BilinearGroup.Type getPairingType() {
        return this.impl.getPairingType();
    }

    @Override
    public Representation getRepresentation() {
        return ReprUtil.serialize(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LazyBilinearGroup that = (LazyBilinearGroup)o;
        return this.impl.equals(that.impl);
    }

    public int hashCode() {
        return Objects.hash(this.impl);
    }

    public String toString() {
        return "LazyBilinearGroup{impl=" + this.impl + '}';
    }
}

