/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.math.structures.rings.integers;

import java.math.BigInteger;
import java.util.Optional;
import org.cryptimeleon.math.random.RandomGenerator;
import org.cryptimeleon.math.serialization.Representation;
import org.cryptimeleon.math.structures.rings.Ring;
import org.cryptimeleon.math.structures.rings.RingElement;
import org.cryptimeleon.math.structures.rings.integers.IntegerElement;

public class IntegerRing
implements Ring {
    public IntegerRing() {
    }

    public IntegerRing(Representation repr) {
    }

    @Override
    public BigInteger size() throws UnsupportedOperationException {
        return null;
    }

    @Override
    public Representation getRepresentation() {
        return null;
    }

    @Override
    public BigInteger sizeUnitGroup() throws UnsupportedOperationException {
        return BigInteger.valueOf(2L);
    }

    @Override
    public IntegerElement getZeroElement() {
        return new IntegerElement(BigInteger.ZERO);
    }

    @Override
    public IntegerElement getOneElement() {
        return new IntegerElement(BigInteger.ONE);
    }

    @Override
    public IntegerElement getElement(BigInteger i) {
        return new IntegerElement(i);
    }

    @Override
    public double estimateCostInvPerOp() {
        return 6.0;
    }

    @Override
    public double estimateCostNegPerOp() {
        return 2.0;
    }

    @Override
    public IntegerElement restoreElement(Representation repr) {
        return new IntegerElement(repr.bigInt().get());
    }

    @Override
    public IntegerElement getUniformlyRandomElement() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("You cannot draw uniformly from an infinite set");
    }

    @Override
    public RingElement getUniformlyRandomUnit() throws UnsupportedOperationException {
        return new IntegerElement(BigInteger.valueOf(-1L).pow(RandomGenerator.getRandomNumber(BigInteger.valueOf(2L)).intValue()));
    }

    @Override
    public BigInteger getCharacteristic() {
        return BigInteger.ZERO;
    }

    public boolean equals(Object obj) {
        return obj instanceof IntegerRing;
    }

    public int hashCode() {
        return 7;
    }

    @Override
    public Optional<Integer> getUniqueByteLength() {
        return Optional.empty();
    }

    @Override
    public boolean isCommutative() {
        return true;
    }

    public static BigInteger[] decomposeIntoDigits(BigInteger number, BigInteger base) {
        int power = 0;
        BigInteger basePower = BigInteger.ONE;
        while (basePower.compareTo(number) < 0) {
            basePower = basePower.multiply(base);
            ++power;
        }
        return IntegerRing.decomposeIntoDigits(number, base, power);
    }

    public static BigInteger[] decomposeIntoDigits(BigInteger number, BigInteger base, int numDigits) {
        if (base.signum() <= 0 || number.signum() < 0 || numDigits < 0) {
            throw new IllegalArgumentException("Parameters must be positive/non-negative");
        }
        BigInteger[] result = new BigInteger[numDigits];
        BigInteger remainder = number;
        for (int j = numDigits - 1; j >= 0; --j) {
            BigInteger basePowJ = base.pow(j);
            BigInteger[] div = remainder.divideAndRemainder(basePowJ);
            result[j] = div[0];
            remainder = div[1];
        }
        if (remainder.signum() != 0) {
            throw new IllegalArgumentException("Unable to represent " + number.toString() + " base " + base.toString() + " with " + numDigits + " digits");
        }
        return result;
    }

    public static BigInteger[] decomposeIntoDigits(BigInteger number, long base) {
        return IntegerRing.decomposeIntoDigits(number, BigInteger.valueOf(base));
    }

    public static BigInteger[] decomposeIntoDigits(BigInteger number, long base, int numDigits) {
        return IntegerRing.decomposeIntoDigits(number, BigInteger.valueOf(base), numDigits);
    }
}

