/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.math.structures.rings.zn;

import java.math.BigInteger;
import java.util.Objects;
import java.util.Optional;
import org.cryptimeleon.math.expressions.bool.ExponentEqualityExpr;
import org.cryptimeleon.math.expressions.exponent.ExponentConstantExpr;
import org.cryptimeleon.math.expressions.exponent.ExponentExpr;
import org.cryptimeleon.math.hash.ByteAccumulator;
import org.cryptimeleon.math.hash.UniqueByteRepresentable;
import org.cryptimeleon.math.random.RandomGenerator;
import org.cryptimeleon.math.serialization.BigIntegerRepresentation;
import org.cryptimeleon.math.serialization.Representation;
import org.cryptimeleon.math.structures.Element;
import org.cryptimeleon.math.structures.rings.Ring;
import org.cryptimeleon.math.structures.rings.RingElement;

public class Zn
implements Ring {
    protected final ZnElement ONE;
    protected final ZnElement ZERO;
    protected final BigInteger n;
    protected Boolean nIsPrime = null;
    protected final int maxByteLength;

    public Zn(BigInteger n) {
        if (n.signum() <= 0) {
            throw new IllegalArgumentException("n must be positive");
        }
        this.n = n;
        this.ONE = this.createZnElement(BigInteger.ONE);
        this.ZERO = this.createZnElement(BigInteger.ZERO);
        this.maxByteLength = n.toByteArray().length;
    }

    public Zn(Representation repr) {
        this(((BigIntegerRepresentation)repr).get());
    }

    @Override
    public BigInteger size() {
        return this.n;
    }

    @Override
    public boolean hasPrimeSize() throws UnsupportedOperationException {
        if (this.nIsPrime == null) {
            this.nIsPrime = this.n.isProbablePrime(80);
        }
        return this.nIsPrime;
    }

    @Override
    public BigInteger sizeUnitGroup() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ZnElement getZeroElement() {
        return this.ZERO;
    }

    @Override
    public ZnElement getOneElement() {
        return this.ONE;
    }

    @Override
    public ZnElement getUniformlyRandomElement() throws UnsupportedOperationException {
        return this.createZnElement(RandomGenerator.getRandomNumber(this.n));
    }

    @Override
    public ZnElement getUniformlyRandomUnit() throws UnsupportedOperationException {
        return (ZnElement)Ring.super.getUniformlyRandomUnit();
    }

    @Override
    public ZnElement getUniformlyRandomNonzeroElement() {
        return this.createZnElement(RandomGenerator.getRandomNonZeroNumber(this.n));
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        return obj instanceof Zn && this.n.equals(((Zn)obj).n);
    }

    public int hashCode() {
        return this.n.hashCode();
    }

    public final int upperBoundForUniqueRepresentation() {
        return this.n.toByteArray().length;
    }

    @Override
    public Representation getRepresentation() {
        return new BigIntegerRepresentation(this.n);
    }

    @Override
    public ZnElement restoreElement(Representation repr) {
        return this.createZnElement(((BigIntegerRepresentation)repr).get());
    }

    public static ZnElement valueOf(BigInteger representative, BigInteger modulus) {
        return new Zn(modulus).valueOf(representative);
    }

    public static ZnElement valueOf(long representative, BigInteger modulus) {
        return Zn.valueOf(BigInteger.valueOf(representative), modulus);
    }

    public static ZnElement valueOf(long representative, long modulus) {
        return Zn.valueOf(representative, BigInteger.valueOf(modulus));
    }

    public ZnElement valueOf(long representative) {
        return this.valueOf(BigInteger.valueOf(representative));
    }

    public ZnElement valueOf(BigInteger representative) {
        return this.createZnElement(representative);
    }

    public ZnElement injectiveValueOf(byte[] bytes) throws IllegalArgumentException {
        if (bytes.length > (this.n.bitLength() - 1) / 8) {
            throw new IllegalArgumentException("Too many bytes to map injectively to Zn (allowed are byte arrays of length " + (this.n.bitLength() - 1) / 8 + ")");
        }
        byte[] normalized = new byte[bytes.length + 1];
        System.arraycopy(bytes, 0, normalized, 1, bytes.length);
        BigInteger result = new BigInteger(normalized);
        if (result.compareTo(this.n) > 0 || result.signum() < 0) {
            throw new RuntimeException("This should not happen");
        }
        return this.createZnElement(result);
    }

    public ZnElement valueOf(byte[] bytes) {
        return this.createZnElement(new BigInteger(1, bytes));
    }

    @Override
    public BigInteger getCharacteristic() {
        return this.size();
    }

    public ZnElement createZnElement(BigInteger v) {
        return this.createZnElementUnsafe(v.mod(this.n));
    }

    protected ZnElement createZnElementUnsafe(BigInteger vBetween0andN) {
        return new ZnElement(vBetween0andN);
    }

    public String toString() {
        return "Z_" + this.n.toString();
    }

    @Override
    public Optional<Integer> getUniqueByteLength() {
        return Optional.of(this.maxByteLength);
    }

    @Override
    public ZnElement getElement(BigInteger i) {
        return this.createZnElement(i);
    }

    @Override
    public double estimateCostInvPerOp() {
        return 0.1;
    }

    @Override
    public double estimateCostNegPerOp() {
        return 1.0;
    }

    @Override
    public boolean isCommutative() {
        return true;
    }

    public class ZnElement
    implements RingElement,
    UniqueByteRepresentable {
        protected final BigInteger v;

        protected ZnElement(BigInteger v) {
            this.v = v;
            if (v.compareTo(Zn.this.n) >= 0 || v.signum() < 0) {
                throw new RuntimeException("The given integer is not in Zn");
            }
        }

        protected ZnElement() {
            this.v = BigInteger.ZERO;
        }

        @Override
        public Zn getStructure() {
            return Zn.this;
        }

        @Override
        public ZnElement add(Element e) {
            this.checkSameModulus(e);
            BigInteger result = this.v.add(((ZnElement)e).v);
            if (result.compareTo(Zn.this.n) >= 0) {
                result = result.subtract(Zn.this.n);
            }
            return Zn.this.createZnElementUnsafe(result);
        }

        public ExponentExpr add(ExponentExpr e) {
            return this.asExponentExpression().add(e);
        }

        @Override
        public ZnElement neg() {
            return this.v.equals(BigInteger.ZERO) ? this : Zn.this.createZnElementUnsafe(Zn.this.n.subtract(this.v));
        }

        @Override
        public ZnElement sub(Element e) {
            this.checkSameModulus(e);
            BigInteger result = this.v.subtract(((ZnElement)e).v);
            if (result.signum() == -1) {
                result = result.add(Zn.this.n);
            }
            return Zn.this.createZnElementUnsafe(result);
        }

        public ExponentExpr sub(ExponentExpr e) {
            return this.asExponentExpression().sub(e);
        }

        @Override
        public ZnElement mul(Element e) {
            this.checkSameModulus(e);
            return Zn.this.createZnElementUnsafe(this.v.multiply(((ZnElement)e).v).mod(Zn.this.n));
        }

        @Override
        public ZnElement mul(BigInteger k) {
            return Zn.this.createZnElementUnsafe(this.v.multiply(k).mod(Zn.this.n));
        }

        @Override
        public ZnElement mul(long k) {
            return this.mul(BigInteger.valueOf(k));
        }

        public ExponentExpr mul(ExponentExpr e) {
            return this.asExponentExpression().mul(e);
        }

        @Override
        public ZnElement pow(BigInteger k) {
            return Zn.this.createZnElementUnsafe(this.v.modPow(k, Zn.this.n));
        }

        @Override
        public ZnElement pow(long k) {
            return this.pow(BigInteger.valueOf(k));
        }

        public ExponentExpr pow(ExponentExpr e) {
            return this.asExponentExpression().pow(e);
        }

        @Override
        public ZnElement inv() throws UnsupportedOperationException {
            try {
                return Zn.this.createZnElementUnsafe(this.v.modInverse(Zn.this.n));
            }
            catch (ArithmeticException e) {
                throw new UnsupportedOperationException("This element (" + this.v + ") is not invertible modulo " + Zn.this.n);
            }
        }

        @Override
        public ZnElement square() {
            return this.mul(this);
        }

        @Override
        public ZnElement div(Element e) throws IllegalArgumentException {
            return (ZnElement)RingElement.super.div(e);
        }

        @Override
        public boolean divides(RingElement e) throws UnsupportedOperationException {
            return this.v.gcd(Zn.this.n).remainder(((ZnElement)e).v).equals(BigInteger.ZERO);
        }

        public ZnElement[] divideWithRemainder(RingElement e) throws UnsupportedOperationException, IllegalArgumentException {
            throw new UnsupportedOperationException();
        }

        @Override
        public BigInteger getRank() throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }

        protected void checkSameModulus(Element e) {
            if (!(e instanceof ZnElement) || !this.getStructure().equals(e.getStructure())) {
                throw new IllegalArgumentException("Cannot compute operations between " + this.getStructure() + " and " + e.getStructure());
            }
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof ZnElement)) {
                return false;
            }
            ZnElement e = (ZnElement)obj;
            return Objects.equals(this.getStructure(), e.getStructure()) && Objects.equals(this.v, e.v);
        }

        @Override
        public int hashCode() {
            return this.v.hashCode();
        }

        @Override
        public Representation getRepresentation() {
            return new BigIntegerRepresentation(this.v);
        }

        public BigInteger getInteger() {
            return this.v;
        }

        public String toString() {
            return this.v.toString();
        }

        @Override
        public ByteAccumulator updateAccumulator(ByteAccumulator accumulator) {
            BigInteger reduced = this.v.mod(Zn.this.n);
            byte[] tmp = reduced.toByteArray();
            byte[] result = new byte[Zn.this.maxByteLength];
            System.arraycopy(tmp, 0, result, Zn.this.maxByteLength - tmp.length, tmp.length);
            accumulator.append(result);
            return accumulator;
        }

        public ExponentConstantExpr asExponentExpression() {
            return new ExponentConstantExpr(this);
        }

        public ExponentEqualityExpr isEqualTo(ExponentExpr other) {
            return this.asExponentExpression().isEqualTo(other);
        }

        public ExponentEqualityExpr isEqualTo(ZnElement other) {
            return this.isEqualTo(other.asExponentExpression());
        }

        public ExponentEqualityExpr isEqualTo(BigInteger other) {
            return this.isEqualTo(Zn.this.valueOf(other));
        }

        public ExponentEqualityExpr isEqualTo(long other) {
            return this.isEqualTo(Zn.this.valueOf(other));
        }

        @Override
        public BigInteger asInteger() throws UnsupportedOperationException {
            return this.v;
        }
    }
}

