/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.math.prf;

import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collection;
import java.util.Random;
import java.util.function.Supplier;
import org.cryptimeleon.math.hash.HashFunction;
import org.cryptimeleon.math.hash.UniqueByteRepresentable;
import org.cryptimeleon.math.hash.impl.SHA256HashFunction;
import org.cryptimeleon.math.hash.impl.SHA512HashFunction;
import org.cryptimeleon.math.misc.ByteArrayImpl;
import org.cryptimeleon.math.prf.PrfKey;
import org.cryptimeleon.math.prf.zn.HashThenPrfToZn;
import org.cryptimeleon.math.structures.rings.zn.Zn;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class HashThenPrfTest {
    private HashThenPrfToZn hashThenPrfToZn;
    private Supplier<UniqueByteRepresentable> hashPreimageSupplier;

    public HashThenPrfTest(TestParams params) {
        this.hashThenPrfToZn = params.hashThenPrfToZn;
        this.hashPreimageSupplier = params.hashPreimageSupplier;
    }

    @Test
    public void testRun() {
        PrfKey k = this.hashThenPrfToZn.generateKey();
        Assert.assertNotNull((Object)this.hashThenPrfToZn.hashThenPrfToZn(k, this.hashPreimageSupplier.get()));
    }

    @Test
    public void testVector() {
        PrfKey k = this.hashThenPrfToZn.generateKey();
        UniqueByteRepresentable preimage = this.hashPreimageSupplier.get();
        Assert.assertNotNull((Object)this.hashThenPrfToZn.hashThenPrfToZnVector(k, preimage, 13));
        Assert.assertNotEquals((Object)this.hashThenPrfToZn.hashThenPrfToZnVector(k, preimage, 12, "preimage1"), (Object)this.hashThenPrfToZn.hashThenPrfToZnVector(k, preimage, 12, "preimage2"));
        Assert.assertNotEquals((Object)this.hashThenPrfToZn.hashThenPrfToZnVector(k, preimage, 12, "preimage2"), (Object)this.hashThenPrfToZn.hashThenPrfToZnVector(k, preimage, 12, ""));
        Assert.assertNotEquals((Object)this.hashThenPrfToZn.hashThenPrfToZnVector(k, preimage, 7), (Object)this.hashThenPrfToZn.hashThenPrfToZnVector(k, preimage, 12).truncate(7));
        Assert.assertEquals((Object)this.hashThenPrfToZn.hashThenPrfToZnVector(k, preimage, 7, "samePreimage"), (Object)this.hashThenPrfToZn.hashThenPrfToZnVector(k, preimage, 7, "samePreimage"));
    }

    @Parameterized.Parameters(name="Test: {0}")
    public static Collection<TestParams[]> data() {
        return Arrays.asList({new TestParams(128, (HashFunction)new SHA256HashFunction(), 30, () -> ByteArrayImpl.fromRandom((int)1024))}, {new TestParams(128, (HashFunction)new SHA256HashFunction(), 470, () -> ByteArrayImpl.fromRandom((int)1024))}, {new TestParams(128, (HashFunction)new SHA256HashFunction(), 1330, () -> ByteArrayImpl.fromRandom((int)1024))}, {new TestParams(128, (HashFunction)new SHA512HashFunction(), 470, () -> ByteArrayImpl.fromRandom((int)1024))}, {new TestParams(256, (HashFunction)new SHA256HashFunction(), 30, () -> ByteArrayImpl.fromRandom((int)1024))}, {new TestParams(256, (HashFunction)new SHA256HashFunction(), 470, () -> ByteArrayImpl.fromRandom((int)1024))}, {new TestParams(256, (HashFunction)new SHA256HashFunction(), 1330, () -> ByteArrayImpl.fromRandom((int)1024))}, {new TestParams(256, (HashFunction)new SHA512HashFunction(), 470, () -> ByteArrayImpl.fromRandom((int)1024))});
    }

    private static class TestParams {
        private int aesKeyLength;
        private HashFunction hashFunction;
        private Zn zn;
        private Supplier<UniqueByteRepresentable> hashPreimageSupplier;
        private HashThenPrfToZn hashThenPrfToZn;
        private int znBitLength;

        public TestParams(int aesKeyLength, HashFunction hashFunction, int znBitLength, Supplier<UniqueByteRepresentable> hashPreimageSupplier) {
            this.aesKeyLength = aesKeyLength;
            this.hashFunction = hashFunction;
            this.hashPreimageSupplier = hashPreimageSupplier;
            this.zn = new Zn(new BigInteger(znBitLength, 64, new Random()));
            this.hashThenPrfToZn = new HashThenPrfToZn(aesKeyLength, this.zn, hashFunction, 128);
            this.znBitLength = znBitLength;
        }

        public String toString() {
            return this.aesKeyLength + "bit AES with " + this.hashFunction.getClass().getName() + ", Zn of size " + this.znBitLength;
        }
    }
}

