/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.math.structures;

import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import java.util.function.Supplier;
import org.cryptimeleon.math.serialization.Representable;
import org.cryptimeleon.math.serialization.RepresentableRepresentation;
import org.cryptimeleon.math.serialization.Representation;
import org.cryptimeleon.math.structures.groups.GroupElementImpl;
import org.cryptimeleon.math.structures.groups.GroupImpl;
import org.cryptimeleon.math.structures.rings.zn.Zn;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class GroupImplTests {
    protected GroupImpl groupImpl;
    protected Supplier<GroupElementImpl> elementSupplier;

    public GroupImplTests(TestParams params) {
        this.groupImpl = params.group;
        this.elementSupplier = params.elementSupplier;
    }

    @Test
    public void testBasicProperties() {
        GroupElementImpl a = null;
        GroupElementImpl b = null;
        try {
            a = this.groupImpl.getUniformlyRandomElement();
        }
        catch (Exception ex) {
            Assert.assertTrue((boolean)(ex instanceof UnsupportedOperationException));
        }
        try {
            a = this.groupImpl.getUniformlyRandomNonNeutral();
        }
        catch (Exception ex) {
            Assert.assertTrue((boolean)(ex instanceof UnsupportedOperationException));
        }
        a = this.elementSupplier.get();
        b = this.elementSupplier.get();
        GroupElementImpl c = this.elementSupplier.get();
        Assert.assertTrue((boolean)a.inv().op(a).equals(this.groupImpl.getNeutralElement()));
        Assert.assertTrue((boolean)a.op(a.inv()).equals(this.groupImpl.getNeutralElement()));
        Assert.assertTrue((boolean)a.op(b).op(c).equals(a.op(b.op(c))));
        if (this.groupImpl.isCommutative()) {
            Assert.assertEquals((String)"Commutativity", (Object)a.op(b), (Object)b.op(a));
        }
        BigInteger exponent = BigInteger.TEN;
        if (this.groupImpl.isCommutative()) {
            Assert.assertEquals((String)"Exponentiation+Commutativity", (Object)a.op(b).pow(exponent), (Object)a.pow(exponent).op(b.pow(exponent)));
        }
        Assert.assertTrue((boolean)a.op(this.groupImpl.getNeutralElement()).equals(a));
        Assert.assertTrue((boolean)this.groupImpl.getNeutralElement().op(a).equals(a));
        GroupElementImpl aToTheFifth = a.op(a).op(a).op(a).op(a);
        Assert.assertEquals((String)"Exponentiation", (Object)a.pow(BigInteger.valueOf(5L)), (Object)aToTheFifth);
        Assert.assertEquals((String)"Exponentiation with negative exponent", (Object)a.pow(BigInteger.valueOf(-5L)), (Object)aToTheFifth.inv());
        BigInteger size = null;
        try {
            size = this.groupImpl.size();
            Assert.assertTrue((size == null || size.signum() >= 0 ? 1 : 0) != 0);
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof UnsupportedOperationException));
        }
        if (size != null) {
            Assert.assertTrue((String)"Lagrange", (boolean)a.pow(size).isNeutralElement());
            Assert.assertTrue((String)"Lagrange inversion", (boolean)a.pow(size.subtract(BigInteger.ONE)).equals(a.inv()));
            BigInteger r = new Zn(this.groupImpl.size()).getUniformlyRandomElement().getInteger();
            if (size.isProbablePrime(100)) {
                Assert.assertTrue((boolean)a.op(b).pow(r).op(b.pow(r.negate())).equals(a.pow(r)));
            } else {
                Assert.assertTrue((boolean)a.pow(r).op(b.pow(r)).op(b.pow(r.negate())).equals(a.pow(r)));
            }
        }
    }

    @Test
    public void testEqualsAndHashCode() {
        GroupElementImpl b;
        GroupElementImpl a = this.elementSupplier.get();
        if (a == (b = a.op(a).op(a.inv()))) {
            System.out.println("Warning: could not test hash code implementation for " + this.groupImpl);
        }
        Assert.assertTrue((a.equals(b) && b.equals(a) ? 1 : 0) != 0);
        Assert.assertTrue((String)"Equal elements should have the same hashCode", (a.hashCode() == b.hashCode() ? 1 : 0) != 0);
    }

    @Test
    public void testUniqueRepresentations() {
        Optional ubrLength = Optional.empty();
        try {
            ubrLength = this.groupImpl.getUniqueByteLength();
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof UnsupportedOperationException));
        }
        if (ubrLength.isPresent()) {
            GroupElementImpl a = this.elementSupplier.get();
            GroupElementImpl b = this.elementSupplier.get();
            try {
                Assert.assertEquals((String)"ubr length", (long)((Integer)ubrLength.get()).intValue(), (long)a.getUniqueByteRepresentation().length);
                Assert.assertEquals((String)"ubr length", (long)((Integer)ubrLength.get()).intValue(), (long)b.getUniqueByteRepresentation().length);
                Assert.assertTrue((String)"Uniqueness", (a.equals(b) || !Arrays.equals(a.getUniqueByteRepresentation(), b.getUniqueByteRepresentation()) ? 1 : 0) != 0);
            }
            catch (Exception e) {
                Assert.assertTrue((boolean)(e instanceof UnsupportedOperationException));
            }
        }
    }

    @Parameterized.Parameters(name="Test: {0}")
    public static Collection<TestParams[]> data() {
        return Arrays.asList(new TestParams[0][]);
    }

    @Test
    public void testStructureRepresentation() {
        RepresentableRepresentation repr = new RepresentableRepresentation((Representable)this.groupImpl);
        GroupImpl s2 = (GroupImpl)repr.recreateRepresentable();
        Assert.assertEquals((String)"Reserialized GroupImpl should be equal to original", (Object)this.groupImpl, (Object)s2);
        Assert.assertEquals((String)"Reserialized GroupImpl's hashCode should be equal to original", (long)this.groupImpl.hashCode(), (long)s2.hashCode());
    }

    @Test
    public void testElementRepresentation() {
        GroupElementImpl elem = this.elementSupplier.get();
        Representation repr = elem.getRepresentation();
        GroupElementImpl elem2 = this.groupImpl.restoreElement(repr);
        Assert.assertEquals((String)"Reserialized element should be equal to original", (Object)elem, (Object)elem2);
        Assert.assertEquals((String)"Reserialized element's hashCode should be equal to original", (long)elem.hashCode(), (long)elem2.hashCode());
    }

    protected static class TestParams {
        GroupImpl group;
        Supplier<GroupElementImpl> elementSupplier;

        public TestParams(GroupImpl group, Supplier<GroupElementImpl> elementSupplier) {
            this.group = group;
            this.elementSupplier = elementSupplier;
        }

        public TestParams(GroupImpl group) {
            this(group, () -> ((GroupImpl)group).getUniformlyRandomElement());
        }

        public String toString() {
            return this.group.getClass().getName() + " - " + this.group.toString();
        }
    }
}

