/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.math.expressions;

import java.math.BigInteger;
import java.util.HashMap;
import org.cryptimeleon.math.expressions.Expression;
import org.cryptimeleon.math.expressions.Substitution;
import org.cryptimeleon.math.expressions.VariableExpression;
import org.cryptimeleon.math.expressions.bool.BoolConstantExpr;
import org.cryptimeleon.math.expressions.bool.BoolVariableExpr;
import org.cryptimeleon.math.expressions.exponent.ExponentConstantExpr;
import org.cryptimeleon.math.expressions.exponent.ExponentVariableExpr;
import org.cryptimeleon.math.expressions.group.GroupElementConstantExpr;
import org.cryptimeleon.math.expressions.group.GroupVariableExpr;
import org.cryptimeleon.math.structures.groups.GroupElement;
import org.cryptimeleon.math.structures.rings.RingElement;
import org.cryptimeleon.math.structures.rings.zn.Zn;
import org.cryptimeleon.math.structures.rings.zn.Zp;

public class ValueBundle
implements Substitution {
    protected HashMap<VariableExpression, GroupElement> groupElems;
    protected HashMap<VariableExpression, BigInteger> ints;
    protected HashMap<VariableExpression, RingElement> ringElems;
    protected HashMap<VariableExpression, Boolean> bools;

    public ValueBundle() {
    }

    public ValueBundle(ValueBundle other) {
        this();
        this.groupElems.putAll(other.groupElems);
        this.ints.putAll(other.ints);
        this.ringElems.putAll(other.ringElems);
        this.bools.putAll(other.bools);
    }

    public ValueBundle copy() {
        return new ValueBundle(this);
    }

    public GroupElement getGroupElement(VariableExpression key) {
        return this.groupElems.get(key);
    }

    public RingElement getRingElement(VariableExpression key) {
        return this.ringElems.get(key);
    }

    public Zn.ZnElement getZnElement(VariableExpression key) {
        return (Zn.ZnElement)this.ringElems.get(key);
    }

    public Zp.ZpElement getZpElement(VariableExpression key) {
        return (Zp.ZpElement)this.ringElems.get(key);
    }

    public Boolean getBoolean(VariableExpression key) {
        return this.bools.get(key);
    }

    public BigInteger getInteger(VariableExpression key) {
        if (this.ints.containsKey(key)) {
            return this.ints.get(key);
        }
        RingElement alternative = this.ringElems.get(key);
        try {
            return alternative.asInteger();
        }
        catch (UnsupportedOperationException e) {
            return null;
        }
    }

    public void put(VariableExpression key, GroupElement value) {
        this.groupElems.put(key, value);
        this.ints.remove(key);
        this.ringElems.remove(key);
        this.bools.remove(key);
    }

    public void put(VariableExpression key, RingElement value) {
        this.ringElems.put(key, value);
        this.ints.remove(key);
        this.groupElems.remove(key);
        this.bools.remove(key);
    }

    public void put(VariableExpression key, BigInteger value) {
        this.ints.put(key, value);
        this.groupElems.remove(key);
        this.ringElems.remove(key);
        this.bools.remove(key);
    }

    public void put(VariableExpression key, boolean value) {
        this.bools.put(key, value);
        this.groupElems.remove(key);
        this.ringElems.remove(key);
        this.ints.remove(key);
    }

    @Override
    public Expression getSubstitution(VariableExpression variable) {
        if (variable instanceof GroupVariableExpr) {
            GroupElement result = this.getGroupElement(variable);
            return result == null ? null : new GroupElementConstantExpr(result);
        }
        if (variable instanceof ExponentVariableExpr) {
            BigInteger result = this.getInteger(variable);
            return result == null ? null : new ExponentConstantExpr(result);
        }
        if (variable instanceof BoolVariableExpr) {
            Boolean result = this.getBoolean(variable);
            return result == null ? null : new BoolConstantExpr(result);
        }
        return null;
    }
}

