/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.math.expressions.exponent;

import java.math.BigInteger;
import java.util.function.Consumer;
import org.cryptimeleon.math.expressions.Expression;
import org.cryptimeleon.math.expressions.Substitution;
import org.cryptimeleon.math.expressions.exponent.ExponentEmptyExpr;
import org.cryptimeleon.math.expressions.exponent.ExponentExpr;
import org.cryptimeleon.math.expressions.exponent.ExponentSumExpr;
import org.cryptimeleon.math.structures.rings.zn.Zn;

public class ExponentConstantExpr
implements ExponentExpr {
    protected final BigInteger exponent;

    public ExponentConstantExpr(BigInteger exponent) {
        this.exponent = exponent;
    }

    public ExponentConstantExpr(Zn.ZnElement exponent) {
        this.exponent = exponent.getInteger();
    }

    public ExponentConstantExpr(long exponent) {
        this.exponent = BigInteger.valueOf(exponent);
    }

    @Override
    public BigInteger evaluate() {
        return this.exponent;
    }

    @Override
    public Zn.ZnElement evaluate(Zn zn) {
        return zn.valueOf(this.exponent);
    }

    @Override
    public ExponentExpr substitute(Substitution substitutions) {
        return this;
    }

    @Override
    public ExponentSumExpr linearize() throws IllegalArgumentException {
        return new ExponentSumExpr(this, new ExponentEmptyExpr());
    }

    @Override
    public void forEachChild(Consumer<Expression> action) {
    }
}

