/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.math.serialization.annotations;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import org.cryptimeleon.math.serialization.ListRepresentation;
import org.cryptimeleon.math.serialization.Representation;
import org.cryptimeleon.math.serialization.annotations.RepresentationHandler;
import org.cryptimeleon.math.serialization.annotations.RepresentationRestorer;

class ListAndSetRepresentationHandler
implements RepresentationHandler {
    private static final Class<?>[] supportedFallbackClasses = new Class[]{ArrayList.class, HashSet.class};
    protected RepresentationHandler elementHandler;
    protected Class<?> collectionType;
    protected Type elementType;

    public ListAndSetRepresentationHandler(RepresentationHandler elementHandler, Type collectionType) {
        this.elementHandler = elementHandler;
        this.collectionType = (Class)((ParameterizedType)collectionType).getRawType();
        this.elementType = ListAndSetRepresentationHandler.getElementType(collectionType);
    }

    public static Type getElementType(Type collectionType) {
        Type[] typeArguments = ((ParameterizedType)collectionType).getActualTypeArguments();
        if (typeArguments.length != 1) {
            throw new IllegalArgumentException("Cannot handle collections with more than one generic type");
        }
        return typeArguments[0];
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean canHandle(Type collectionType) {
        if (!(collectionType instanceof ParameterizedType)) {
            return false;
        }
        Type rawType = ((ParameterizedType)collectionType).getRawType();
        if (!(rawType instanceof Class)) {
            return false;
        }
        if (!List.class.isAssignableFrom((Class)rawType) && !Set.class.isAssignableFrom((Class)rawType)) {
            return false;
        }
        try {
            ListAndSetRepresentationHandler.getElementType(collectionType);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        try {
            ((Class)rawType).getConstructor(new Class[0]);
            return true;
        }
        catch (NoSuchMethodException e) {
            if (!((Class)rawType).isInterface()) return false;
            if (!Arrays.stream(supportedFallbackClasses).anyMatch(((Class)rawType)::isAssignableFrom)) return false;
            return true;
        }
    }

    @Override
    public Object deserializeFromRepresentation(Representation repr, Function<String, RepresentationRestorer> getRegisteredRestorer) {
        if (repr == null) {
            return null;
        }
        Collection result = null;
        try {
            result = (Collection)this.collectionType.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException e) {
            for (Class<?> fallback : supportedFallbackClasses) {
                try {
                    if (!this.collectionType.isAssignableFrom(fallback)) continue;
                    result = (Collection)fallback.getConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException ex) {
                    throw new RuntimeException("Cannot instantiate type " + this.collectionType.getName());
                }
                catch (InvocationTargetException ex) {
                    if (e.getCause() instanceof RuntimeException) {
                        throw (RuntimeException)ex.getCause();
                    }
                    throw new RuntimeException("An error occured during invocation of the constructor of " + fallback.getSimpleName(), ex);
                }
            }
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw new RuntimeException("An error occured during invocation of the constructor of " + this.collectionType.getSimpleName(), e);
        }
        if (result == null) {
            throw new RuntimeException("Cannot instantiate type " + this.collectionType.getName());
        }
        for (Representation inner : repr.list()) {
            result.add(this.elementHandler.deserializeFromRepresentation(inner, getRegisteredRestorer));
        }
        return result;
    }

    @Override
    public Representation serializeToRepresentation(Object obj) {
        if (obj == null) {
            return null;
        }
        if (!(obj instanceof List) && !(obj instanceof Set)) {
            throw new IllegalArgumentException("Cannot handle representation of " + obj.getClass().getName());
        }
        if (!(obj instanceof List)) {
            obj = Arrays.asList(((Set)((Object)obj)).toArray());
            Collections.shuffle(obj);
        }
        ListRepresentation repr = new ListRepresentation();
        for (Object inner : (Iterable)obj) {
            repr.put(this.elementHandler.serializeToRepresentation(inner));
        }
        return repr;
    }
}

