/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.math.serialization.converter;

import java.math.BigInteger;
import java.util.Base64;
import java.util.Comparator;
import java.util.LinkedHashMap;
import org.cryptimeleon.math.serialization.BigIntegerRepresentation;
import org.cryptimeleon.math.serialization.ByteArrayRepresentation;
import org.cryptimeleon.math.serialization.ListRepresentation;
import org.cryptimeleon.math.serialization.MapRepresentation;
import org.cryptimeleon.math.serialization.ObjectRepresentation;
import org.cryptimeleon.math.serialization.RepresentableRepresentation;
import org.cryptimeleon.math.serialization.Representation;
import org.cryptimeleon.math.serialization.StringRepresentation;
import org.cryptimeleon.math.serialization.converter.Converter;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class JSONConverter
extends Converter<String> {
    protected static final String BIG_INTEGER_PREFIX = "INT:";
    protected static final String BYTE_ARRAY_PREFIX = "BYTES:";
    protected static final String STRING_PREFIX = "STRING:";
    protected static final String OBJ_TYPE_KEY = "__type";
    protected static final String MAP_OBJ_TYPE = "MAP";
    protected static final String REPR_OBJ_TYPE = "REPR";
    protected static final String OBJ_OBJ_TYPE = "OBJ";

    @Override
    public String serialize(Representation r) {
        return JSONValue.toJSONString((Object)this.internalSerialize(r));
    }

    protected Object internalSerialize(Representation r) {
        if (r == null) {
            return null;
        }
        if (r instanceof BigIntegerRepresentation) {
            return this.serializeBigInteger((BigIntegerRepresentation)r);
        }
        if (r instanceof ByteArrayRepresentation) {
            return this.serializeByteArray((ByteArrayRepresentation)r);
        }
        if (r instanceof ListRepresentation) {
            return this.serializeList((ListRepresentation)r);
        }
        if (r instanceof ObjectRepresentation) {
            return this.serializeObjectRepr((ObjectRepresentation)r);
        }
        if (r instanceof StringRepresentation) {
            return this.serializeString((StringRepresentation)r);
        }
        if (r instanceof RepresentableRepresentation) {
            return this.serializeRepresentable((RepresentableRepresentation)r);
        }
        if (r instanceof MapRepresentation) {
            return this.serializeMap((MapRepresentation)r);
        }
        throw new IllegalArgumentException("Unknown type when serializing: " + r.getClass().getName());
    }

    private LinkedHashMap<String, Object> serializeObjectRepr(ObjectRepresentation r) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        result.put(OBJ_TYPE_KEY, OBJ_OBJ_TYPE);
        r.forEachOrderedByKeys((key, value) -> {
            if (key.startsWith(OBJ_TYPE_KEY)) {
                key = OBJ_TYPE_KEY + key;
            }
            result.put((String)key, this.internalSerialize((Representation)value));
        });
        return result;
    }

    private LinkedHashMap<String, Object> serializeMap(MapRepresentation r) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        result.put(OBJ_TYPE_KEY, MAP_OBJ_TYPE);
        JSONArray tuples = new JSONArray();
        r.getMap().entrySet().stream().sorted(Comparator.comparing(x -> ((Representation)x.getKey()).toString()).thenComparing(x -> ((Representation)x.getValue()).toString())).forEachOrdered(x -> {
            JSONArray tuple = new JSONArray();
            tuple.add(this.internalSerialize((Representation)x.getKey()));
            tuple.add(this.internalSerialize((Representation)x.getValue()));
            tuples.add((Object)tuple);
        });
        result.put("map", tuples);
        return result;
    }

    private JSONArray serializeList(ListRepresentation r) {
        JSONArray result = new JSONArray();
        for (Representation x : r) {
            result.add(this.internalSerialize(x));
        }
        return result;
    }

    private LinkedHashMap<String, Object> serializeRepresentable(RepresentableRepresentation r) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        result.put(OBJ_TYPE_KEY, REPR_OBJ_TYPE);
        result.put("class", r.getRepresentedTypeName());
        result.put("repr", this.internalSerialize(r.getRepresentation()));
        return result;
    }

    private String serializeBigInteger(BigIntegerRepresentation r) {
        return BIG_INTEGER_PREFIX + r.get().toString(16);
    }

    private String serializeByteArray(ByteArrayRepresentation r) {
        return BYTE_ARRAY_PREFIX + Base64.getEncoder().encodeToString(r.get());
    }

    private String serializeString(StringRepresentation s) {
        return STRING_PREFIX + s.get();
    }

    @Override
    public Representation deserialize(String s) {
        try {
            return this.internalDeserialize(new JSONParser().parse(s));
        }
        catch (ParseException e) {
            e.printStackTrace();
            throw new IllegalArgumentException("Error when parsing JSON: " + s);
        }
    }

    protected Representation internalDeserialize(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof JSONObject) {
            switch ((String)((JSONObject)o).get((Object)OBJ_TYPE_KEY)) {
                case "REPR": {
                    return this.deserializeRepresentable((JSONObject)o);
                }
                case "MAP": {
                    return this.deserializeMap((JSONObject)o);
                }
                case "OBJ": {
                    return this.deserializeObject((JSONObject)o);
                }
            }
        }
        if (o instanceof JSONArray) {
            return this.deserializeArray((JSONArray)o);
        }
        if (o instanceof String) {
            if (((String)o).startsWith(BIG_INTEGER_PREFIX)) {
                return this.deserializeBigInteger((String)o);
            }
            if (((String)o).startsWith(BYTE_ARRAY_PREFIX)) {
                return this.deserializeByteArray((String)o);
            }
            if (((String)o).startsWith(STRING_PREFIX)) {
                return this.deserializeString((String)o);
            }
            throw new IllegalArgumentException("Cannot handle type prefix of " + o);
        }
        throw new IllegalArgumentException("Unexpected JSON element");
    }

    private RepresentableRepresentation deserializeRepresentable(JSONObject o) {
        return new RepresentableRepresentation((String)o.get((Object)"class"), this.internalDeserialize(o.get((Object)"repr")));
    }

    private MapRepresentation deserializeMap(JSONObject o) {
        MapRepresentation result = new MapRepresentation();
        ((JSONArray)o.get((Object)"map")).forEach(x -> result.put(this.internalDeserialize(((JSONArray)x).get(0)), this.internalDeserialize(((JSONArray)x).get(1))));
        return result;
    }

    private StringRepresentation deserializeString(String o) {
        return new StringRepresentation(o.substring(STRING_PREFIX.length()));
    }

    private BigIntegerRepresentation deserializeBigInteger(String o) {
        return new BigIntegerRepresentation(new BigInteger(o.substring(BIG_INTEGER_PREFIX.length()), 16));
    }

    private ByteArrayRepresentation deserializeByteArray(String o) {
        return new ByteArrayRepresentation(Base64.getDecoder().decode(o.substring(BYTE_ARRAY_PREFIX.length())));
    }

    private ListRepresentation deserializeArray(JSONArray o) {
        ListRepresentation result = new ListRepresentation();
        o.forEach(x -> result.put(this.internalDeserialize(x)));
        return result;
    }

    private ObjectRepresentation deserializeObject(JSONObject o) {
        ObjectRepresentation result = new ObjectRepresentation();
        o.forEach((k, v) -> {
            String key = (String)k;
            if (key.startsWith(OBJ_TYPE_KEY)) {
                key = key.substring(OBJ_TYPE_KEY.length());
            }
            if (!key.isEmpty()) {
                result.put(key, this.internalDeserialize(v));
            }
        });
        return result;
    }
}

