/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.math.structures.groups;

import java.lang.reflect.Type;
import java.math.BigInteger;
import org.cryptimeleon.math.expressions.group.GroupElementExpression;
import org.cryptimeleon.math.expressions.group.GroupEmptyExpr;
import org.cryptimeleon.math.serialization.Representation;
import org.cryptimeleon.math.serialization.annotations.RepresentationRestorer;
import org.cryptimeleon.math.structures.Structure;
import org.cryptimeleon.math.structures.groups.GroupElement;
import org.cryptimeleon.math.structures.groups.cartesian.GroupElementVector;
import org.cryptimeleon.math.structures.rings.cartesian.RingElementVector;
import org.cryptimeleon.math.structures.rings.zn.Zn;

public interface Group
extends Structure,
RepresentationRestorer {
    public GroupElement getNeutralElement();

    @Override
    public GroupElement getUniformlyRandomElement() throws UnsupportedOperationException;

    default public GroupElementVector getUniformlyRandomElements(int n) throws UnsupportedOperationException {
        return GroupElementVector.generate(this::getUniformlyRandomElement, n);
    }

    default public GroupElement getUniformlyRandomNonNeutral() {
        GroupElement result;
        while ((result = this.getUniformlyRandomElement()).isNeutralElement()) {
        }
        return result;
    }

    default public GroupElementVector getUniformlyRandomNonNeutrals(int n) {
        return GroupElementVector.generate(this::getUniformlyRandomNonNeutral, n);
    }

    @Override
    public GroupElement restoreElement(Representation var1);

    default public GroupElementVector restoreVector(Representation repr) {
        return GroupElementVector.fromStream(repr.list().stream().map(this::restoreElement));
    }

    default public GroupElement getGenerator() throws UnsupportedOperationException {
        if (this.hasPrimeSize()) {
            return this.getUniformlyRandomNonNeutral();
        }
        throw new UnsupportedOperationException("Can't compute generator for group: " + this);
    }

    public boolean isCommutative();

    default public GroupElementExpression expr() {
        return new GroupEmptyExpr(this);
    }

    @Override
    default public Object restoreFromRepresentation(Type type, Representation repr) {
        if (type instanceof Class && GroupElement.class.isAssignableFrom((Class)type)) {
            return this.restoreElement(repr);
        }
        if (type instanceof Class && GroupElementVector.class.isAssignableFrom((Class)type)) {
            return this.restoreVector(repr);
        }
        throw new IllegalArgumentException("Group cannot recreate type " + type.getTypeName() + " from representation");
    }

    default public Zn getZn() {
        BigInteger size = this.size();
        if (size == null) {
            throw new IllegalArgumentException("Infinitely large group - cannot output corresponding Zn");
        }
        return new Zn(size);
    }

    default public Zn.ZnElement getUniformlyRandomExponent() {
        return this.getZn().getUniformlyRandomElement();
    }

    default public RingElementVector getUniformlyRandomExponents(int n) {
        return RingElementVector.generate(this::getUniformlyRandomExponent, n);
    }

    default public Zn.ZnElement getUniformlyRandomUnitExponent() {
        return this.getZn().getUniformlyRandomUnit();
    }

    default public RingElementVector getUniformlyRandomUnitExponents(int n) {
        return RingElementVector.generate(this::getUniformlyRandomUnitExponent, n);
    }

    default public Zn.ZnElement getUniformlyRandomNonzeroExponent() {
        return this.getZn().getUniformlyRandomNonzeroElement();
    }

    default public RingElementVector getUniformlyRandomNonzeroExponents(int n) {
        return RingElementVector.generate(this::getUniformlyRandomNonzeroExponent, n);
    }
}

