/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.math.structures.groups.debug;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Objects;
import org.cryptimeleon.math.random.RandomGenerator;
import org.cryptimeleon.math.serialization.Representation;
import org.cryptimeleon.math.serialization.annotations.ReprUtil;
import org.cryptimeleon.math.serialization.annotations.Represented;
import org.cryptimeleon.math.structures.groups.debug.DebugBilinearMapImpl;
import org.cryptimeleon.math.structures.groups.debug.DebugGroupImpl;
import org.cryptimeleon.math.structures.groups.debug.DebugIsomorphismImpl;
import org.cryptimeleon.math.structures.groups.debug.HashIntoDebugGroupImpl;
import org.cryptimeleon.math.structures.groups.elliptic.BilinearGroup;
import org.cryptimeleon.math.structures.groups.elliptic.BilinearGroupImpl;
import org.cryptimeleon.math.structures.groups.elliptic.BilinearMapImpl;
import org.cryptimeleon.math.structures.groups.mappings.impl.GroupHomomorphismImpl;
import org.cryptimeleon.math.structures.groups.mappings.impl.HashIntoGroupImpl;

public class DebugBilinearGroupImpl
implements BilinearGroupImpl {
    @Represented
    protected Integer securityParameter;
    @Represented
    protected BilinearGroup.Type pairingType;
    @Represented
    protected BigInteger size;
    @Represented
    protected Boolean enableExpCounting;
    @Represented
    protected Boolean enableMultiExpCounting;
    DebugBilinearMapImpl bilinearMapImpl;

    public DebugBilinearGroupImpl(int securityParameter, BilinearGroup.Type pairingType, int numPrimeFactors, boolean enableExpCounting, boolean enableMultiExpCounting) {
        this.securityParameter = securityParameter;
        this.pairingType = pairingType;
        this.enableExpCounting = enableExpCounting;
        this.enableMultiExpCounting = enableMultiExpCounting;
        ArrayList<BigInteger> primeFactors = new ArrayList<BigInteger>();
        for (int i = 0; i < numPrimeFactors; ++i) {
            primeFactors.add(RandomGenerator.getRandomPrime(securityParameter));
        }
        this.size = primeFactors.stream().reduce(BigInteger.ONE, BigInteger::multiply);
        this.init();
    }

    public DebugBilinearGroupImpl(int securityParameter, BilinearGroup.Type pairingType, int numPrimeFactors) {
        this(securityParameter, pairingType, numPrimeFactors, false, false);
    }

    public DebugBilinearGroupImpl(int securityParameter, BilinearGroup.Type pairingType) {
        this(securityParameter, pairingType, 1);
    }

    public DebugBilinearGroupImpl(int securityParameter, BilinearGroup.Type pairingType, BigInteger size, boolean enableExpCounting, boolean enableMultiExpCounting) {
        this.securityParameter = securityParameter;
        this.pairingType = pairingType;
        this.enableExpCounting = enableExpCounting;
        this.enableMultiExpCounting = enableMultiExpCounting;
        this.size = size;
        this.init();
    }

    protected void init() {
        this.bilinearMapImpl = new DebugBilinearMapImpl(this.pairingType, this.size, this.enableExpCounting, this.enableMultiExpCounting);
    }

    public DebugBilinearGroupImpl(Representation repr) {
        ReprUtil.deserialize(this, repr);
        this.init();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        DebugBilinearGroupImpl that = (DebugBilinearGroupImpl)other;
        return Objects.equals((Object)this.pairingType, (Object)that.pairingType) && Objects.equals(this.size, that.size) && Objects.equals(this.enableExpCounting, that.enableExpCounting) && Objects.equals(this.enableMultiExpCounting, that.enableMultiExpCounting);
    }

    public int hashCode() {
        return Objects.hash(this.pairingType.ordinal(), this.size);
    }

    @Override
    public Representation getRepresentation() {
        return ReprUtil.serialize(this);
    }

    @Override
    public DebugGroupImpl getG1() {
        return this.bilinearMapImpl.g1;
    }

    @Override
    public DebugGroupImpl getG2() {
        return this.bilinearMapImpl.g2;
    }

    @Override
    public DebugGroupImpl getGT() {
        return this.bilinearMapImpl.gt;
    }

    @Override
    public BilinearMapImpl getBilinearMap() {
        return this.bilinearMapImpl;
    }

    @Override
    public GroupHomomorphismImpl getHomomorphismG2toG1() throws UnsupportedOperationException {
        if (this.pairingType != BilinearGroup.Type.TYPE_1 && this.pairingType != BilinearGroup.Type.TYPE_2) {
            throw new UnsupportedOperationException("Didn't require existence of a group homomorphism");
        }
        return new DebugIsomorphismImpl(this.getG2(), this.getG1());
    }

    @Override
    public HashIntoGroupImpl getHashIntoG1() throws UnsupportedOperationException {
        return new HashIntoDebugGroupImpl(this.getG1());
    }

    @Override
    public HashIntoGroupImpl getHashIntoG2() throws UnsupportedOperationException {
        return new HashIntoDebugGroupImpl(this.getG2());
    }

    @Override
    public HashIntoGroupImpl getHashIntoGT() throws UnsupportedOperationException {
        return new HashIntoDebugGroupImpl(this.getGT());
    }

    @Override
    public Integer getSecurityLevel() {
        return this.securityParameter;
    }

    @Override
    public BilinearGroup.Type getPairingType() {
        return this.pairingType;
    }
}

