/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.math.structures.groups.debug;

import java.math.BigInteger;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.cryptimeleon.math.serialization.Representation;
import org.cryptimeleon.math.serialization.annotations.ReprUtil;
import org.cryptimeleon.math.serialization.annotations.Represented;
import org.cryptimeleon.math.structures.groups.Group;
import org.cryptimeleon.math.structures.groups.GroupElement;
import org.cryptimeleon.math.structures.groups.debug.DebugGroupElement;
import org.cryptimeleon.math.structures.groups.debug.DebugGroupImpl;
import org.cryptimeleon.math.structures.groups.exp.ExpAlgorithm;
import org.cryptimeleon.math.structures.groups.exp.MultiExpAlgorithm;
import org.cryptimeleon.math.structures.groups.lazy.LazyGroup;
import org.cryptimeleon.math.structures.groups.lazy.LazyGroupElement;
import org.cryptimeleon.math.structures.rings.zn.Zn;

public class DebugGroup
implements Group {
    @Represented
    LazyGroup groupTotal;
    @Represented
    LazyGroup groupExpMultiExp;

    public DebugGroup(String name, BigInteger n) {
        this.groupTotal = new LazyGroup(new DebugGroupImpl(name, n, false, false));
        this.groupExpMultiExp = new LazyGroup(new DebugGroupImpl(name, n, true, true));
    }

    public DebugGroup(String name, long n) {
        this(name, BigInteger.valueOf(n));
    }

    public DebugGroup(LazyGroup groupTotal, LazyGroup groupExpMultiExp) {
        this.groupTotal = groupTotal;
        this.groupExpMultiExp = groupExpMultiExp;
    }

    public DebugGroup(Representation repr) {
        new ReprUtil(this).deserialize(repr);
    }

    @Override
    public GroupElement getNeutralElement() {
        return new DebugGroupElement(this, (LazyGroupElement)this.groupTotal.getNeutralElement(), (LazyGroupElement)this.groupExpMultiExp.getNeutralElement());
    }

    @Override
    public BigInteger size() throws UnsupportedOperationException {
        return this.groupTotal.size();
    }

    @Override
    public Zn getZn() {
        return this.groupTotal.getZn();
    }

    @Override
    public GroupElement getUniformlyRandomElement() throws UnsupportedOperationException {
        return new DebugGroupElement(this, (LazyGroupElement)this.groupTotal.getUniformlyRandomElement(), (LazyGroupElement)this.groupExpMultiExp.getUniformlyRandomElement());
    }

    @Override
    public GroupElement restoreElement(Representation repr) {
        return new DebugGroupElement(this, repr);
    }

    public DebugGroupElement wrap(Zn.ZnElement elem) {
        return new DebugGroupElement(this, this.groupTotal.wrap(((DebugGroupImpl)this.groupTotal.getImpl()).wrap(elem)), this.groupExpMultiExp.wrap(((DebugGroupImpl)this.groupExpMultiExp.getImpl()).wrap(elem)));
    }

    @Override
    public Optional<Integer> getUniqueByteLength() {
        Optional<Integer> totalLength = this.groupTotal.getUniqueByteLength();
        Optional<Integer> expMultiExpLength = this.groupExpMultiExp.getUniqueByteLength();
        if (!totalLength.isPresent() || !expMultiExpLength.isPresent()) {
            return Optional.empty();
        }
        return Optional.of(totalLength.get() + expMultiExpLength.get());
    }

    @Override
    public boolean isCommutative() {
        return this.groupTotal.isCommutative();
    }

    @Override
    public Representation getRepresentation() {
        return ReprUtil.serialize(this);
    }

    public long getNumSquaringsTotal() {
        return ((DebugGroupImpl)this.groupTotal.getImpl()).getNumSquarings();
    }

    public long getNumInversionsTotal() {
        return ((DebugGroupImpl)this.groupTotal.getImpl()).getNumInversions();
    }

    public long getNumOpsTotal() {
        return ((DebugGroupImpl)this.groupTotal.getImpl()).getNumOps();
    }

    public long getNumSquaringsNoExpMultiExp() {
        return ((DebugGroupImpl)this.groupExpMultiExp.getImpl()).getNumSquarings();
    }

    public long getNumInversionsNoExpMultiExp() {
        return ((DebugGroupImpl)this.groupExpMultiExp.getImpl()).getNumInversions();
    }

    public long getNumOpsNoExpMultiExp() {
        return ((DebugGroupImpl)this.groupExpMultiExp.getImpl()).getNumOps();
    }

    public long getNumExps() {
        return ((DebugGroupImpl)this.groupExpMultiExp.getImpl()).getNumExps();
    }

    public List<Integer> getMultiExpTermNumbers() {
        return ((DebugGroupImpl)this.groupExpMultiExp.getImpl()).getMultiExpTermNumbers();
    }

    public long getNumRetrievedRepresentations() {
        return ((DebugGroupImpl)this.groupTotal.getImpl()).getNumRetrievedRepresentations();
    }

    public void resetCounters() {
        ((DebugGroupImpl)this.groupTotal.getImpl()).resetCounters();
        ((DebugGroupImpl)this.groupExpMultiExp.getImpl()).resetCounters();
    }

    public String formatCounterData() {
        return "------- Operation data for " + this.toString() + " -------\n----- Total group operation data: -----\n    Number of Group Operations: " + this.getNumOpsTotal() + "\n    Number of Group Inversions: " + this.getNumInversionsTotal() + "\n    Number of Group Squarings: " + this.getNumSquaringsTotal() + "\n----- Group operation data without operations done in (multi-)exp algorithms: -----\n    Number of Group Operations: " + this.getNumOpsNoExpMultiExp() + "\n    Number of Group Inversions: " + this.getNumInversionsNoExpMultiExp() + "\n    Number of Group Squarings: " + this.getNumSquaringsNoExpMultiExp() + "\n----- Other data: -----\n    Number of exponentiations: " + this.getNumExps() + "\n    Number of terms in each multi-exponentiation: " + this.getMultiExpTermNumbers() + "\n    Number of retrieved representations (via getRepresentation()): " + this.getNumRetrievedRepresentations() + "\n";
    }

    public int getExponentiationWindowSize() {
        return this.groupTotal.getExponentiationWindowSize();
    }

    public void setExponentiationWindowSize(int exponentiationWindowSize) {
        this.groupTotal.setExponentiationWindowSize(exponentiationWindowSize);
        this.groupExpMultiExp.setExponentiationWindowSize(exponentiationWindowSize);
    }

    public int getPrecomputationWindowSize() {
        return this.groupTotal.getPrecomputationWindowSize();
    }

    public void setPrecomputationWindowSize(int precomputationWindowSize) {
        this.groupTotal.setPrecomputationWindowSize(precomputationWindowSize);
        this.groupExpMultiExp.setPrecomputationWindowSize(precomputationWindowSize);
    }

    public MultiExpAlgorithm getSelectedMultiExpAlgorithm() {
        return this.groupTotal.getSelectedMultiExpAlgorithm();
    }

    public void setSelectedMultiExpAlgorithm(MultiExpAlgorithm selectedMultiExpAlgorithm) {
        this.groupTotal.setSelectedMultiExpAlgorithm(selectedMultiExpAlgorithm);
        this.groupExpMultiExp.setSelectedMultiExpAlgorithm(selectedMultiExpAlgorithm);
    }

    public ExpAlgorithm getSelectedExpAlgorithm() {
        return this.groupTotal.getSelectedExpAlgorithm();
    }

    public void setSelectedExpAlgorithm(ExpAlgorithm selectedExpAlgorithm) {
        this.groupTotal.setSelectedExpAlgorithm(selectedExpAlgorithm);
        this.groupExpMultiExp.setSelectedExpAlgorithm(selectedExpAlgorithm);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DebugGroup other = (DebugGroup)o;
        return Objects.equals(this.groupTotal, other.groupTotal) && Objects.equals(this.groupExpMultiExp, other.groupExpMultiExp);
    }

    public int hashCode() {
        return Objects.hash(this.groupTotal, this.groupExpMultiExp);
    }

    public String toString() {
        DebugGroupImpl debugImpl = (DebugGroupImpl)this.groupTotal.getImpl();
        return this.getClass().getSimpleName() + " with name " + debugImpl.name + " of size " + debugImpl.size();
    }
}

