/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.math.structures.groups.debug;

import java.util.Objects;
import org.cryptimeleon.math.serialization.Representation;
import org.cryptimeleon.math.structures.groups.GroupElementImpl;
import org.cryptimeleon.math.structures.groups.debug.DebugGroupImpl;
import org.cryptimeleon.math.structures.groups.mappings.impl.HashIntoGroupImpl;
import org.cryptimeleon.math.structures.rings.zn.HashIntoZn;

public class HashIntoDebugGroupImpl
implements HashIntoGroupImpl {
    protected DebugGroupImpl group;
    protected HashIntoZn hash;

    public HashIntoDebugGroupImpl(DebugGroupImpl group) {
        this.group = group;
        this.hash = new HashIntoZn(group.size());
    }

    public HashIntoDebugGroupImpl(Representation repr) {
        this(new DebugGroupImpl(repr));
    }

    @Override
    public Representation getRepresentation() {
        return this.group.getRepresentation();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HashIntoDebugGroupImpl that = (HashIntoDebugGroupImpl)o;
        return Objects.equals(this.group, that.group);
    }

    public int hashCode() {
        return Objects.hash(this.group);
    }

    @Override
    public GroupElementImpl hashIntoGroupImpl(byte[] x) {
        return this.group.wrap(this.hash.hash(x));
    }
}

