/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.math.structures.groups.exp;

import java.math.BigInteger;
import org.cryptimeleon.math.structures.groups.GroupElementImpl;
import org.cryptimeleon.math.structures.groups.exp.SmallExponentPrecomputation;

public class MultiExpTerm {
    protected final GroupElementImpl base;
    protected final BigInteger exponent;
    protected final SmallExponentPrecomputation precomputation;

    public MultiExpTerm(GroupElementImpl base, BigInteger exponent, SmallExponentPrecomputation precomputation) {
        if (precomputation == null) {
            precomputation = new SmallExponentPrecomputation(base);
        }
        this.base = base;
        this.precomputation = precomputation;
        this.exponent = exponent;
    }

    public MultiExpTerm(GroupElementImpl base, BigInteger exponent) {
        this(base, exponent, new SmallExponentPrecomputation(base));
    }

    public GroupElementImpl getBase() {
        return this.base;
    }

    public BigInteger getExponent() {
        return this.exponent;
    }

    public SmallExponentPrecomputation getPrecomputation() {
        return this.precomputation;
    }

    public String toString() {
        return "MultiExpTerm: Base(" + this.base + ") Exponent(" + this.exponent + ") Precomputation(PosWindowSize: " + this.precomputation.getCurrentlySupportedPositiveWindowSize() + " | NegWindowSize: " + this.precomputation.getCurrentlySupportedNegativeWindowSize() + ")";
    }
}

