/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.math.structures.rings.cartesian;

import java.math.BigInteger;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.cryptimeleon.math.expressions.exponent.ExponentConstantExpr;
import org.cryptimeleon.math.serialization.ListRepresentation;
import org.cryptimeleon.math.serialization.Representable;
import org.cryptimeleon.math.serialization.Representation;
import org.cryptimeleon.math.structures.cartesian.ExponentExpressionVector;
import org.cryptimeleon.math.structures.cartesian.Vector;
import org.cryptimeleon.math.structures.rings.RingElement;
import org.cryptimeleon.math.structures.rings.cartesian.ProductRingElement;

public class RingElementVector
extends Vector<RingElement>
implements Representable {
    public RingElementVector(RingElement ... values) {
        super(values);
    }

    public RingElementVector(List<RingElement> values) {
        super(values);
    }

    protected RingElementVector(RingElement[] values, boolean isSafe) {
        super((X[])values, isSafe);
    }

    protected RingElementVector(List<? extends RingElement> values, boolean isSafe) {
        super(values, isSafe);
    }

    public RingElementVector(Vector<? extends RingElement> vector) {
        super(vector);
    }

    public RingElementVector mul(Vector<? extends RingElement> other) {
        return this.zip(other, RingElement::mul, RingElementVector::instantiateWithSafeArray);
    }

    public RingElementVector mul(RingElement elem) {
        return this.map((X g) -> g.mul(elem), RingElementVector::instantiateWithSafeArray);
    }

    public RingElementVector mul(BigInteger factor) {
        return this.map((X g) -> g.mul(factor), RingElementVector::instantiateWithSafeArray);
    }

    public RingElementVector mul(Long factor) {
        return this.map((X g) -> g.mul(factor), RingElementVector::instantiateWithSafeArray);
    }

    public RingElementVector add(RingElement elem) {
        return this.map((X g) -> g.add(elem), RingElementVector::instantiateWithSafeArray);
    }

    public RingElementVector pow(BigInteger exponent) {
        return this.map((X g) -> g.pow(exponent), RingElementVector::instantiateWithSafeArray);
    }

    public RingElementVector pow(long exponent) {
        return this.map((X g) -> g.pow(exponent), RingElementVector::instantiateWithSafeArray);
    }

    public RingElementVector pow(Vector<?> exponents) {
        return this.zip(exponents, (g, x) -> x instanceof Long ? g.pow((Long)x) : g.pow((BigInteger)x), RingElementVector::new);
    }

    public RingElement innerProduct(Vector<? extends RingElement> rightHandSide, RingElement zeroElement) {
        return this.zipReduce(rightHandSide, RingElement::mul, RingElement::add, zeroElement);
    }

    public RingElement innerProduct(Vector<? extends RingElement> rightHandSide) {
        return this.innerProduct(rightHandSide, null);
    }

    private static RingElementVector instantiateWithSafeArray(List<? extends RingElement> array) {
        return new RingElementVector(array, true);
    }

    public static RingElementVector iterate(RingElement initialValue, Function<RingElement, RingElement> nextValue, int n) {
        return Vector.iterate(initialValue, nextValue, n, RingElementVector::instantiateWithSafeArray);
    }

    public static RingElementVector generate(Function<Integer, ? extends RingElement> generator, int n) {
        return RingElementVector.generatePlain(generator, n, RingElementVector::instantiateWithSafeArray);
    }

    public static RingElementVector generate(Supplier<? extends RingElement> generator, int n) {
        return RingElementVector.generatePlain(generator, n, RingElementVector::instantiateWithSafeArray);
    }

    public static RingElementVector of(RingElement ... vals) {
        return new RingElementVector(vals, false);
    }

    public static RingElementVector fromStream(Stream<? extends RingElement> stream) {
        return RingElementVector.fromStreamPlain(stream, RingElementVector::instantiateWithSafeArray);
    }

    @Override
    public Representation getRepresentation() {
        return new ListRepresentation(this.map(Representable::getRepresentation).toList());
    }

    public RingElementVector pad(RingElement valueToPadWith, int desiredLength) {
        return new RingElementVector((Vector<? extends RingElement>)super.pad(valueToPadWith, desiredLength));
    }

    public RingElementVector replace(int index, RingElement substitute) {
        return new RingElementVector((Vector<? extends RingElement>)super.replace(index, substitute));
    }

    public RingElementVector truncate(int newLength) {
        return new RingElementVector(super.truncate(newLength));
    }

    public RingElementVector concatenate(Vector<? extends RingElement> secondPart) {
        return new RingElementVector(super.concatenate(secondPart));
    }

    public RingElementVector append(RingElement valueToAppend) {
        return new RingElementVector((Vector<? extends RingElement>)super.append(valueToAppend));
    }

    public RingElementVector prepend(RingElement valueToPrepend) {
        return new RingElementVector((Vector<? extends RingElement>)super.prepend(valueToPrepend));
    }

    public ProductRingElement asElementInProductRing() {
        return new ProductRingElement(this.values);
    }

    public ExponentExpressionVector asExponentExpr() {
        return this.map((X v) -> new ExponentConstantExpr(v.asInteger()), ExponentExpressionVector::new);
    }
}

