/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.math.serialization.standalone.params;

import java.math.BigInteger;
import org.cryptimeleon.math.random.RandomGenerator;
import org.cryptimeleon.math.serialization.StandaloneRepresentable;
import org.cryptimeleon.math.serialization.standalone.StandaloneReprSubTest;
import org.cryptimeleon.math.structures.groups.Group;
import org.cryptimeleon.math.structures.groups.basic.BasicBilinearGroup;
import org.cryptimeleon.math.structures.groups.cartesian.ProductGroup;
import org.cryptimeleon.math.structures.groups.debug.DebugBilinearGroup;
import org.cryptimeleon.math.structures.groups.debug.DebugBilinearGroupImpl;
import org.cryptimeleon.math.structures.groups.debug.DebugGroupImplNoExpMultiExp;
import org.cryptimeleon.math.structures.groups.debug.DebugGroupImplTotal;
import org.cryptimeleon.math.structures.groups.elliptic.BilinearGroup;
import org.cryptimeleon.math.structures.groups.elliptic.BilinearGroupImpl;
import org.cryptimeleon.math.structures.groups.elliptic.type1.supersingular.SupersingularBasicBilinearGroup;
import org.cryptimeleon.math.structures.groups.elliptic.type1.supersingular.SupersingularBilinearGroup;
import org.cryptimeleon.math.structures.groups.elliptic.type3.bn.BarretoNaehrigBasicBilinearGroup;
import org.cryptimeleon.math.structures.groups.elliptic.type3.bn.BarretoNaehrigBilinearGroup;
import org.cryptimeleon.math.structures.groups.lazy.LazyBilinearGroup;
import org.cryptimeleon.math.structures.groups.sn.Sn;
import org.cryptimeleon.math.structures.rings.Ring;
import org.cryptimeleon.math.structures.rings.cartesian.ProductRing;
import org.cryptimeleon.math.structures.rings.extfield.ExtensionField;
import org.cryptimeleon.math.structures.rings.polynomial.PolynomialRing;
import org.cryptimeleon.math.structures.rings.zn.HashIntoZn;
import org.cryptimeleon.math.structures.rings.zn.HashIntoZnAdditiveGroup;
import org.cryptimeleon.math.structures.rings.zn.HashIntoZp;
import org.cryptimeleon.math.structures.rings.zn.Zn;
import org.cryptimeleon.math.structures.rings.zn.Zp;

public class StructureStandaloneReprTest
extends StandaloneReprSubTest {
    private final Zn zn = new Zn(BigInteger.valueOf(100000L));
    private final Zp zp = new Zp(BigInteger.valueOf(100003L));

    public void testBilinearGroup(BilinearGroup bilGroup) {
        this.test((StandaloneRepresentable)bilGroup);
        this.test((StandaloneRepresentable)bilGroup.getG1());
        this.test((StandaloneRepresentable)bilGroup.getG2());
        this.test((StandaloneRepresentable)bilGroup.getGT());
        try {
            this.test((StandaloneRepresentable)bilGroup.getHashIntoG1());
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            this.test((StandaloneRepresentable)bilGroup.getHashIntoG2());
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            this.test((StandaloneRepresentable)bilGroup.getHashIntoGT());
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            this.test((StandaloneRepresentable)bilGroup.getHomomorphismG2toG1());
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void testBilinearGroupImpl(BilinearGroupImpl bilGroup) {
        this.test((StandaloneRepresentable)bilGroup);
        this.test((StandaloneRepresentable)bilGroup.getG1());
        this.test((StandaloneRepresentable)bilGroup.getG2());
        this.test((StandaloneRepresentable)bilGroup.getGT());
        try {
            this.test((StandaloneRepresentable)bilGroup.getHashIntoG1());
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            this.test((StandaloneRepresentable)bilGroup.getHashIntoG2());
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            this.test((StandaloneRepresentable)bilGroup.getHashIntoGT());
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            this.test((StandaloneRepresentable)bilGroup.getHomomorphismG2toG1());
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void testBarretoNaehrig() {
        this.testBilinearGroup((BilinearGroup)new BarretoNaehrigBasicBilinearGroup(80));
        this.testBilinearGroup((BilinearGroup)new BarretoNaehrigBilinearGroup(80));
    }

    public void testSupersingular() {
        this.testBilinearGroup((BilinearGroup)new SupersingularBasicBilinearGroup(80));
        this.testBilinearGroup((BilinearGroup)new SupersingularBilinearGroup(80));
    }

    public void testLazyAndBasicGroup() {
        DebugBilinearGroupImpl bilGroupImpl = new DebugBilinearGroupImpl(RandomGenerator.getRandomPrime((int)128), BilinearGroup.Type.TYPE_3, false);
        this.testBilinearGroup((BilinearGroup)new LazyBilinearGroup((BilinearGroupImpl)bilGroupImpl));
        this.testBilinearGroup((BilinearGroup)new BasicBilinearGroup((BilinearGroupImpl)bilGroupImpl));
    }

    public void testDebugGroup() {
        this.testBilinearGroup((BilinearGroup)new DebugBilinearGroup(BilinearGroup.Type.TYPE_1));
        this.testBilinearGroupImpl((BilinearGroupImpl)new DebugBilinearGroupImpl(RandomGenerator.getRandomPrime((int)128), BilinearGroup.Type.TYPE_1, false));
        this.testBilinearGroupImpl((BilinearGroupImpl)new DebugBilinearGroupImpl(RandomGenerator.getRandomPrime((int)128), BilinearGroup.Type.TYPE_1, true));
        this.test((StandaloneRepresentable)new DebugGroupImplTotal("DGIT", RandomGenerator.getRandomPrime((int)128)));
        this.test((StandaloneRepresentable)new DebugGroupImplNoExpMultiExp("DGINEME", RandomGenerator.getRandomPrime((int)128)));
    }

    public void testExtensionField() {
        this.test((StandaloneRepresentable)new ExtensionField(BigInteger.valueOf(17L)));
    }

    public void testProductStructures() {
        this.test((StandaloneRepresentable)new ProductGroup(new Group[]{this.zn.asAdditiveGroup(), this.zp.asUnitGroup()}));
        this.test((StandaloneRepresentable)new ProductRing(new Ring[]{this.zp, this.zn}));
    }

    public void testRingGroups() {
        this.test((StandaloneRepresentable)this.zp.asUnitGroup());
        this.test((StandaloneRepresentable)this.zp.asAdditiveGroup());
    }

    public void testRings() {
        this.test((StandaloneRepresentable)this.zp);
        this.test((StandaloneRepresentable)this.zn);
        this.test((StandaloneRepresentable)new HashIntoZn((Zn)this.zp));
        this.test((StandaloneRepresentable)new HashIntoZp(this.zp));
        this.test((StandaloneRepresentable)new HashIntoZnAdditiveGroup((Zn)this.zp));
        this.test((StandaloneRepresentable)new PolynomialRing((Ring)this.zp));
    }

    public void testSn() {
        this.test((StandaloneRepresentable)new Sn(20));
    }
}

