/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.math.expressions;

import org.cryptimeleon.math.expressions.Expression;
import org.cryptimeleon.math.expressions.VariableExpression;

@FunctionalInterface
public interface Substitution {
    public Expression getSubstitution(VariableExpression var1);

    default public Substitution joinDisjoint(Substitution other) {
        return expr -> {
            Expression ours = this.getSubstitution(expr);
            Expression theirs = other.getSubstitution(expr);
            if (ours != null && theirs != null) {
                throw new IllegalArgumentException("Substitutions are not disjoint");
            }
            return theirs == null ? ours : theirs;
        };
    }

    default public Substitution join(Substitution other) {
        return expr -> {
            Expression ours = this.getSubstitution(expr);
            if (ours == null) {
                return other.getSubstitution(expr);
            }
            return ours;
        };
    }

    public static Substitution join(Substitution ... subs) {
        return expr -> {
            for (Substitution sub : subs) {
                Expression result = sub.getSubstitution(expr);
                if (result == null) continue;
                return result;
            }
            return null;
        };
    }

    public static Substitution joinAndIgnoreNullpointers(Substitution ... subs) {
        return expr -> {
            for (Substitution sub : subs) {
                try {
                    Expression result = sub.getSubstitution(expr);
                    if (result == null) continue;
                    return result;
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
            return null;
        };
    }

    public static Substitution joinDisjoint(Substitution ... subs) {
        return expr -> {
            int numResults = 0;
            Expression result = null;
            for (Substitution sub : subs) {
                result = sub.getSubstitution(expr);
                ++numResults;
            }
            if (numResults > 1) {
                throw new IllegalArgumentException("Substitutions are not disjoint");
            }
            return result;
        };
    }
}

