/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.math.hash;

import org.cryptimeleon.math.hash.ByteAccumulator;

public class EscapingByteAccumulator
extends ByteAccumulator {
    protected ByteAccumulator acc;
    protected byte escapedSymbol;

    public EscapingByteAccumulator(ByteAccumulator acc) {
        this(acc, SEPARATOR);
    }

    public EscapingByteAccumulator(ByteAccumulator acc, byte escapedSymbol) {
        this.acc = acc;
        this.escapedSymbol = escapedSymbol;
    }

    @Override
    public void append(byte[] bytes) {
        for (byte b : bytes) {
            if (Byte.compare(b, this.escapedSymbol) == 1) {
                this.acc.append(new byte[]{this.escapedSymbol});
                this.acc.append(new byte[]{this.escapedSymbol});
                continue;
            }
            this.acc.append(new byte[]{b});
        }
    }

    @Override
    public byte[] extractBytes() {
        return this.acc.extractBytes();
    }
}

