/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.math.hash.impl;

import org.cryptimeleon.math.hash.HashFunction;
import org.cryptimeleon.math.hash.UniqueByteRepresentable;
import org.cryptimeleon.math.hash.impl.SHAHashAccumulator;
import org.cryptimeleon.math.serialization.Representation;
import org.cryptimeleon.math.serialization.StandaloneRepresentable;

abstract class AbstractSHAHashFunction
implements HashFunction,
StandaloneRepresentable {
    protected final String algorithm;

    AbstractSHAHashFunction(String algorithm) {
        this.algorithm = algorithm;
    }

    @Override
    public byte[] hash(UniqueByteRepresentable ubr) {
        SHAHashAccumulator accu = new SHAHashAccumulator(this.algorithm);
        accu.append(ubr.getUniqueByteRepresentation());
        return accu.extractBytes();
    }

    @Override
    public Representation getRepresentation() {
        return null;
    }

    @Override
    public byte[] hash(byte[] bytes) {
        SHAHashAccumulator accu = new SHAHashAccumulator(this.algorithm);
        accu.append(bytes);
        return accu.extractBytes();
    }
}

