/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.math.hash.impl;

import java.nio.ByteBuffer;
import java.util.Objects;
import org.cryptimeleon.math.hash.HashFunction;
import org.cryptimeleon.math.hash.impl.SHA256HashFunction;
import org.cryptimeleon.math.serialization.Representation;
import org.cryptimeleon.math.serialization.StandaloneRepresentable;
import org.cryptimeleon.math.serialization.annotations.ReprUtil;
import org.cryptimeleon.math.serialization.annotations.Represented;

public class VariableOutputLengthHashFunction
implements HashFunction,
StandaloneRepresentable {
    @Represented
    private HashFunction innerFunction;
    @Represented
    private Integer outputLength;

    public VariableOutputLengthHashFunction(int outputLength) {
        this(new SHA256HashFunction(), outputLength);
    }

    public HashFunction getInnerHashFunction() {
        return this.innerFunction;
    }

    public VariableOutputLengthHashFunction(HashFunction hashFunction, int outputLength) {
        this.innerFunction = hashFunction;
        this.outputLength = outputLength;
        if (outputLength <= 0) {
            throw new IllegalArgumentException("Output length should be positive, but is " + outputLength);
        }
    }

    public VariableOutputLengthHashFunction(Representation repr) {
        new ReprUtil(this).deserialize(repr);
    }

    @Override
    public Representation getRepresentation() {
        return ReprUtil.serialize(this);
    }

    @Override
    public byte[] hash(byte[] x) {
        byte[] result = new byte[this.outputLength.intValue()];
        int bytesFilled = 0;
        byte[] y = this.innerFunction.hash(this.prependInt(0, x));
        int c = 1;
        while (bytesFilled < result.length) {
            byte[] hash = this.innerFunction.hash(this.prependInt(c++, y));
            for (int i = 0; i < hash.length && bytesFilled < result.length; ++i) {
                result[bytesFilled++] = hash[i];
            }
        }
        return result;
    }

    private byte[] prependInt(int c, byte[] value) {
        byte[] result = new byte[4 + value.length];
        ByteBuffer b = ByteBuffer.wrap(result);
        b.putInt(c);
        b.put(value);
        return result;
    }

    @Override
    public int getOutputLength() {
        return this.outputLength;
    }

    public int hashCode() {
        return Objects.hash(this.innerFunction, this.outputLength);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VariableOutputLengthHashFunction that = (VariableOutputLengthHashFunction)obj;
        return Objects.equals(this.innerFunction, that.innerFunction) && Objects.equals(this.outputLength, that.outputLength);
    }
}

