/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.math.prf.aes;

import java.util.Objects;
import org.cryptimeleon.math.misc.ByteArrayImpl;
import org.cryptimeleon.math.prf.PrfKey;
import org.cryptimeleon.math.prf.PrfPreimage;
import org.cryptimeleon.math.prf.PseudorandomFunction;
import org.cryptimeleon.math.prf.aes.AesPseudorandomFunction;
import org.cryptimeleon.math.serialization.Representation;
import org.cryptimeleon.math.serialization.annotations.ReprUtil;
import org.cryptimeleon.math.serialization.annotations.Represented;

public class LongAesPseudoRandomFunction
implements PseudorandomFunction {
    @Represented
    private AesPseudorandomFunction aesPseudorandomFunction;
    @Represented
    private Integer factor;
    private int preimageLengthBytes;
    private int keyLengthBytes;

    public LongAesPseudoRandomFunction(AesPseudorandomFunction aesPseudorandomFunction, int k) {
        this.aesPseudorandomFunction = aesPseudorandomFunction;
        this.factor = k;
        this.init();
    }

    public LongAesPseudoRandomFunction(Representation repr) {
        new ReprUtil(this).deserialize(repr);
        this.init();
    }

    private void init() {
        this.preimageLengthBytes = this.aesPseudorandomFunction.getKeylength() / 8;
        this.keyLengthBytes = this.preimageLengthBytes * this.factor;
    }

    @Override
    public ByteArrayImpl generateKey() {
        return ByteArrayImpl.fromRandom(this.keyLengthBytes);
    }

    @Override
    public ByteArrayImpl evaluate(PrfKey k, PrfPreimage x) {
        if (((ByteArrayImpl)k).length() != this.keyLengthBytes) {
            throw new IllegalArgumentException("key k in the AES PRF has invalid length");
        }
        if (((ByteArrayImpl)x).length() != this.preimageLengthBytes) {
            throw new IllegalArgumentException("preimage x in the AES PRF has invalid length");
        }
        ByteArrayImpl result = new ByteArrayImpl(new byte[0]);
        for (int i = 0; i < this.factor; ++i) {
            ByteArrayImpl ki = ((ByteArrayImpl)k).substring(i * this.preimageLengthBytes, this.preimageLengthBytes);
            byte[] bytesToAppend = ((ByteArrayImpl)this.aesPseudorandomFunction.evaluate(ki, x)).getData();
            result = result.append(new ByteArrayImpl(bytesToAppend));
        }
        return result;
    }

    @Override
    public ByteArrayImpl restoreKey(Representation repr) {
        return new ByteArrayImpl(repr);
    }

    @Override
    public ByteArrayImpl restorePreimage(Representation repr) {
        return new ByteArrayImpl(repr);
    }

    @Override
    public ByteArrayImpl restoreImage(Representation repr) {
        return new ByteArrayImpl(repr);
    }

    @Override
    public Representation getRepresentation() {
        return ReprUtil.serialize(this);
    }

    public int getPreimageLengthBytes() {
        return this.preimageLengthBytes;
    }

    public int getKeyLengthBytes() {
        return this.keyLengthBytes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LongAesPseudoRandomFunction that = (LongAesPseudoRandomFunction)o;
        return this.factor.equals(that.factor) && Objects.equals(this.aesPseudorandomFunction, that.aesPseudorandomFunction);
    }

    public int hashCode() {
        return Objects.hash(this.aesPseudorandomFunction, this.factor);
    }
}

