/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.math.prf.zn;

import java.math.BigInteger;
import java.util.Arrays;
import java.util.Objects;
import org.cryptimeleon.math.hash.HashFunction;
import org.cryptimeleon.math.hash.UniqueByteRepresentable;
import org.cryptimeleon.math.hash.impl.ByteArrayAccumulator;
import org.cryptimeleon.math.misc.ByteArrayImpl;
import org.cryptimeleon.math.prf.PrfKey;
import org.cryptimeleon.math.prf.aes.AesPseudorandomFunction;
import org.cryptimeleon.math.prf.aes.LongAesPseudoRandomFunction;
import org.cryptimeleon.math.serialization.Representation;
import org.cryptimeleon.math.serialization.StandaloneRepresentable;
import org.cryptimeleon.math.serialization.annotations.ReprUtil;
import org.cryptimeleon.math.serialization.annotations.Represented;
import org.cryptimeleon.math.structures.rings.RingElement;
import org.cryptimeleon.math.structures.rings.cartesian.RingElementVector;
import org.cryptimeleon.math.structures.rings.zn.Zn;

public class HashThenPrfToZn
implements StandaloneRepresentable {
    @Represented
    private LongAesPseudoRandomFunction longAesPseudoRandomFunction;
    @Represented
    private HashFunction hashFunction;
    @Represented
    private Zn zn;
    private BigInteger maxQuotient;

    public HashThenPrfToZn(int aesKeyLength, Zn zn, HashFunction hashFunction, int oversubscription) {
        if (hashFunction.getOutputLength() * 8 < aesKeyLength) {
            throw new IllegalArgumentException("Hash function output should be larger or equal to AES input size.");
        }
        this.hashFunction = hashFunction;
        this.zn = zn;
        this.longAesPseudoRandomFunction = new LongAesPseudoRandomFunction(new AesPseudorandomFunction(aesKeyLength), (zn.getCharacteristic().bitLength() + aesKeyLength + oversubscription + 1) / aesKeyLength);
        this.init();
    }

    public HashThenPrfToZn(Representation repr) {
        new ReprUtil(this).deserialize(repr);
        this.init();
    }

    private void init() {
        BigInteger p = this.zn.getCharacteristic();
        byte[] bytes = new byte[this.longAesPseudoRandomFunction.getKeyLengthBytes()];
        Arrays.fill(bytes, (byte)-1);
        BigInteger[] dar = new BigInteger(1, bytes).divideAndRemainder(p);
        this.maxQuotient = dar[0];
    }

    public PrfKey generateKey() {
        return this.longAesPseudoRandomFunction.generateKey();
    }

    public RingElementVector hashThenPrfToZnVector(PrfKey prfKey, UniqueByteRepresentable hashInput, int vectorSize, String prefix) {
        RingElement[] result = new RingElement[vectorSize];
        for (int i = 0; i < vectorSize; ++i) {
            ByteArrayAccumulator accumulator = new ByteArrayAccumulator();
            accumulator.append(vectorSize);
            accumulator.append(i);
            accumulator.escapeAndSeparate(prefix);
            accumulator.escapeAndAppend(hashInput);
            Zn.ZnElement element = this.hashThenPrfToZn(prfKey, accumulator.extractBytes());
            result[i] = element;
        }
        return new RingElementVector(result);
    }

    private Zn.ZnElement hashThenPrfToZn(PrfKey prfKey, byte[] hashInput) {
        BigInteger p = this.zn.getCharacteristic();
        byte[] hashOutput = this.hashFunction.hash(hashInput);
        byte[] prfInput = new byte[this.longAesPseudoRandomFunction.getPreimageLengthBytes()];
        System.arraycopy(hashOutput, 0, prfInput, 0, this.longAesPseudoRandomFunction.getPreimageLengthBytes());
        ByteArrayImpl prfOutput = this.longAesPseudoRandomFunction.evaluate(prfKey, new ByteArrayImpl(prfInput));
        BigInteger[] quotientAndRemainder = new BigInteger(1, prfOutput.getData()).divideAndRemainder(p);
        if (quotientAndRemainder[0].compareTo(this.maxQuotient) >= 0) {
            throw new RuntimeException("PRF output is in the reject interval!");
        }
        return this.zn.valueOf(quotientAndRemainder[1]);
    }

    public RingElementVector hashThenPrfToZnVector(PrfKey prfKey, UniqueByteRepresentable hashInput, int vectorSize) {
        return this.hashThenPrfToZnVector(prfKey, hashInput, vectorSize, "");
    }

    public Zn.ZnElement hashThenPrfToZn(PrfKey prfKey, UniqueByteRepresentable hashInput) {
        return (Zn.ZnElement)this.hashThenPrfToZnVector(prfKey, hashInput, 1, "").get(0);
    }

    public Zn.ZnElement hashThenPrfToZn(PrfKey prfKey, UniqueByteRepresentable hashInput, String prefix) {
        return (Zn.ZnElement)this.hashThenPrfToZnVector(prfKey, hashInput, 1, prefix).get(0);
    }

    public LongAesPseudoRandomFunction getLongAesPseudoRandomFunction() {
        return this.longAesPseudoRandomFunction;
    }

    public HashFunction getHashFunction() {
        return this.hashFunction;
    }

    @Override
    public Representation getRepresentation() {
        return ReprUtil.serialize(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HashThenPrfToZn prfToZn = (HashThenPrfToZn)o;
        return Objects.equals(this.longAesPseudoRandomFunction, prfToZn.longAesPseudoRandomFunction) && Objects.equals(this.hashFunction, prfToZn.hashFunction) && Objects.equals(this.zn, prfToZn.zn) && Objects.equals(this.maxQuotient, prfToZn.maxQuotient);
    }

    public int hashCode() {
        return Objects.hash(this.longAesPseudoRandomFunction, this.hashFunction, this.zn, this.maxQuotient);
    }
}

