/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.math.structures.groups.debug;

import java.math.BigInteger;
import java.util.Objects;
import org.cryptimeleon.math.serialization.Representation;
import org.cryptimeleon.math.serialization.annotations.ReprUtil;
import org.cryptimeleon.math.serialization.annotations.Represented;
import org.cryptimeleon.math.structures.groups.debug.DebugBilinearMapImpl;
import org.cryptimeleon.math.structures.groups.debug.DebugGroupImpl;
import org.cryptimeleon.math.structures.groups.debug.DebugIsomorphismImpl;
import org.cryptimeleon.math.structures.groups.debug.HashIntoDebugGroupImpl;
import org.cryptimeleon.math.structures.groups.elliptic.BilinearGroup;
import org.cryptimeleon.math.structures.groups.elliptic.BilinearGroupImpl;
import org.cryptimeleon.math.structures.groups.elliptic.BilinearMapImpl;
import org.cryptimeleon.math.structures.groups.mappings.impl.GroupHomomorphismImpl;
import org.cryptimeleon.math.structures.groups.mappings.impl.HashIntoGroupImpl;

public class DebugBilinearGroupImpl
implements BilinearGroupImpl {
    @Represented
    protected Integer securityParameter;
    @Represented
    protected BilinearGroup.Type pairingType;
    @Represented
    protected BigInteger size;
    @Represented
    protected Boolean enableExpMultiExpCounting;
    DebugBilinearMapImpl bilinearMapImpl;

    public DebugBilinearGroupImpl(BigInteger groupSize, BilinearGroup.Type pairingType, boolean enableExpMultiExpCounting) {
        this.securityParameter = groupSize.bitLength();
        this.pairingType = pairingType;
        this.enableExpMultiExpCounting = enableExpMultiExpCounting;
        this.size = groupSize;
        this.init();
    }

    protected void init() {
        this.bilinearMapImpl = new DebugBilinearMapImpl(this.size, this.pairingType, this.enableExpMultiExpCounting);
    }

    public DebugBilinearGroupImpl(Representation repr) {
        ReprUtil.deserialize(this, repr);
        this.init();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        DebugBilinearGroupImpl that = (DebugBilinearGroupImpl)other;
        return Objects.equals((Object)this.pairingType, (Object)that.pairingType) && Objects.equals(this.size, that.size) && Objects.equals(this.enableExpMultiExpCounting, that.enableExpMultiExpCounting);
    }

    public int hashCode() {
        return Objects.hash(this.pairingType.ordinal(), this.size);
    }

    @Override
    public Representation getRepresentation() {
        return ReprUtil.serialize(this);
    }

    @Override
    public DebugGroupImpl getG1() {
        return this.bilinearMapImpl.g1;
    }

    @Override
    public DebugGroupImpl getG2() {
        return this.bilinearMapImpl.g2;
    }

    @Override
    public DebugGroupImpl getGT() {
        return this.bilinearMapImpl.gt;
    }

    @Override
    public BilinearMapImpl getBilinearMap() {
        return this.bilinearMapImpl;
    }

    @Override
    public GroupHomomorphismImpl getHomomorphismG2toG1() throws UnsupportedOperationException {
        if (this.pairingType != BilinearGroup.Type.TYPE_1 && this.pairingType != BilinearGroup.Type.TYPE_2) {
            throw new UnsupportedOperationException("Didn't require existence of a group homomorphism");
        }
        return new DebugIsomorphismImpl(this.getG2(), this.getG1());
    }

    @Override
    public HashIntoGroupImpl getHashIntoG1() throws UnsupportedOperationException {
        return new HashIntoDebugGroupImpl(this.getG1());
    }

    @Override
    public HashIntoGroupImpl getHashIntoG2() throws UnsupportedOperationException {
        return new HashIntoDebugGroupImpl(this.getG2());
    }

    @Override
    public HashIntoGroupImpl getHashIntoGT() throws UnsupportedOperationException {
        return new HashIntoDebugGroupImpl(this.getGT());
    }

    @Override
    public Integer getSecurityLevel() {
        return this.securityParameter;
    }

    @Override
    public BilinearGroup.Type getPairingType() {
        return this.pairingType;
    }

    public String toString() {
        return this.getClass().getSimpleName() + String.format("(securityParameter=%s, pairingType=%s, size=%s, separateExpMultiExpCounting=%s", new Object[]{this.securityParameter, this.pairingType, this.size, this.enableExpMultiExpCounting});
    }
}

