/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.math.structures.groups.debug;

import java.math.BigInteger;
import java.util.HashSet;
import java.util.Objects;
import org.cryptimeleon.math.structures.groups.Group;
import org.cryptimeleon.math.structures.groups.GroupElement;
import org.cryptimeleon.math.structures.groups.debug.DebugBilinearMapImpl;
import org.cryptimeleon.math.structures.groups.debug.DebugGroup;
import org.cryptimeleon.math.structures.groups.debug.DebugGroupElement;
import org.cryptimeleon.math.structures.groups.elliptic.BilinearMap;
import org.cryptimeleon.math.structures.groups.lazy.LazyBilinearMap;
import org.cryptimeleon.math.structures.groups.lazy.LazyGroup;
import org.cryptimeleon.math.structures.groups.lazy.LazyGroupElement;

public class DebugBilinearMap
implements BilinearMap {
    LazyBilinearMap bilMapTotal;
    LazyBilinearMap bilMapNoExpMultiExp;

    public DebugBilinearMap(LazyBilinearMap bilMapTotal, LazyBilinearMap bilMapNoExpMultiExp) {
        this.bilMapTotal = bilMapTotal;
        this.bilMapNoExpMultiExp = bilMapNoExpMultiExp;
    }

    @Override
    public Group getG1() {
        return new DebugGroup((LazyGroup)this.bilMapTotal.getG1(), (LazyGroup)this.bilMapNoExpMultiExp.getG1());
    }

    @Override
    public Group getG2() {
        return new DebugGroup((LazyGroup)this.bilMapTotal.getG2(), (LazyGroup)this.bilMapNoExpMultiExp.getG2());
    }

    @Override
    public Group getGT() {
        return new DebugGroup((LazyGroup)this.bilMapTotal.getGT(), (LazyGroup)this.bilMapNoExpMultiExp.getGT());
    }

    @Override
    public GroupElement apply(GroupElement g1, GroupElement g2, BigInteger exponent) {
        DebugGroupElement g1Cast = (DebugGroupElement)g1;
        DebugGroupElement g2Cast = (DebugGroupElement)g2;
        LazyGroupElement g1Result = (LazyGroupElement)this.bilMapTotal.apply((GroupElement)g1Cast.elemTotal, (GroupElement)g2Cast.elemTotal, exponent);
        LazyGroupElement g2Result = (LazyGroupElement)this.bilMapNoExpMultiExp.apply((GroupElement)g1Cast.elemExpMultiExp, (GroupElement)g2Cast.elemExpMultiExp, exponent);
        return new DebugGroupElement((DebugGroup)this.getGT(), g1Result, g2Result);
    }

    @Override
    public GroupElement apply(GroupElement g1, GroupElement g2) {
        DebugGroupElement g1Cast = (DebugGroupElement)g1;
        DebugGroupElement g2Cast = (DebugGroupElement)g2;
        LazyGroupElement g1Result = (LazyGroupElement)this.bilMapTotal.apply(g1Cast.elemTotal, g2Cast.elemTotal);
        LazyGroupElement g2Result = (LazyGroupElement)this.bilMapNoExpMultiExp.apply(g1Cast.elemExpMultiExp, g2Cast.elemExpMultiExp);
        return new DebugGroupElement((DebugGroup)this.getGT(), g1Result, g2Result);
    }

    @Override
    public boolean isSymmetric() {
        return this.bilMapTotal.isSymmetric() && this.bilMapNoExpMultiExp.isSymmetric();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        DebugBilinearMap that = (DebugBilinearMap)other;
        return Objects.equals(this.bilMapTotal, that.bilMapTotal) && Objects.equals(this.bilMapNoExpMultiExp, that.bilMapNoExpMultiExp);
    }

    public int hashCode() {
        return Objects.hash(this.bilMapTotal, this.bilMapNoExpMultiExp);
    }

    public void setBucket(String name) {
        ((DebugBilinearMapImpl)this.bilMapTotal.getImpl()).setBucket(name);
        ((DebugBilinearMapImpl)this.bilMapNoExpMultiExp.getImpl()).setBucket(name);
    }

    public void setDefaultBucket() {
        ((DebugBilinearMapImpl)this.bilMapTotal.getImpl()).setDefaultBucket();
        ((DebugBilinearMapImpl)this.bilMapNoExpMultiExp.getImpl()).setDefaultBucket();
    }

    public long getNumPairings(String bucketName) {
        return ((DebugBilinearMapImpl)this.bilMapTotal.getImpl()).getNumPairings(bucketName) / 2L;
    }

    public long getNumPairings() {
        return ((DebugBilinearMapImpl)this.bilMapTotal.getImpl()).getNumPairings() / 2L;
    }

    public long getNumPairingsAllBuckets() {
        return ((DebugBilinearMapImpl)this.bilMapTotal.getImpl()).getNumPairingsAllBuckets() / 2L;
    }

    public void resetNumPairings(String bucketName) {
        ((DebugBilinearMapImpl)this.bilMapTotal.getImpl()).resetNumPairings(bucketName);
        ((DebugBilinearMapImpl)this.bilMapNoExpMultiExp.getImpl()).resetNumPairings(bucketName);
    }

    public void resetNumPairings() {
        ((DebugBilinearMapImpl)this.bilMapTotal.getImpl()).resetNumPairings();
        ((DebugBilinearMapImpl)this.bilMapNoExpMultiExp.getImpl()).resetNumPairings();
    }

    public void resetNumPairingsAllBuckets() {
        ((DebugBilinearMapImpl)this.bilMapTotal.getImpl()).resetNumPairingsAllBuckets();
        ((DebugBilinearMapImpl)this.bilMapNoExpMultiExp.getImpl()).resetNumPairingsAllBuckets();
    }

    public String toString() {
        return this.bilMapTotal.toString();
    }

    public String formatCounterData(String bucketName) {
        String tab = "    ";
        return String.format("%s\n", bucketName) + String.format("%sPairings: %d\n", tab, this.getNumPairings(bucketName)) + tab + "G1\n" + ((DebugGroup)this.getG1()).formatCounterData(bucketName, true, false) + tab + "G2\n" + ((DebugGroup)this.getG2()).formatCounterData(bucketName, true, false) + tab + "GT\n" + ((DebugGroup)this.getGT()).formatCounterData(bucketName, true, false);
    }

    public String formatCounterData() {
        String tab = "    ";
        return "Default\n" + String.format("%sPairings: %d\n", tab, this.getNumPairings()) + tab + "G1\n" + ((DebugGroup)this.getG1()).formatCounterData("", true, true) + tab + "G2\n" + ((DebugGroup)this.getG2()).formatCounterData("", true, true) + tab + "GT\n" + ((DebugGroup)this.getGT()).formatCounterData("", true, true);
    }

    public String formatCounterDataAllBuckets() {
        return this.formatCounterDataAllBuckets(false);
    }

    public String formatCounterDataAllBuckets(boolean summaryOnly) {
        StringBuilder result = new StringBuilder();
        if (!summaryOnly) {
            result.append(this.formatCounterData());
            HashSet<String> bucketNameSet = new HashSet<String>();
            bucketNameSet.addAll(((DebugBilinearMapImpl)this.bilMapTotal.getImpl()).getBucketMap().keySet());
            bucketNameSet.addAll(((DebugBilinearMapImpl)this.bilMapNoExpMultiExp.getImpl()).getBucketMap().keySet());
            bucketNameSet.addAll(((DebugBilinearMapImpl)this.bilMapNoExpMultiExp.getImpl()).g1.getBucketMap().keySet());
            bucketNameSet.addAll(((DebugBilinearMapImpl)this.bilMapTotal.getImpl()).g1.getBucketMap().keySet());
            bucketNameSet.addAll(((DebugBilinearMapImpl)this.bilMapNoExpMultiExp.getImpl()).g2.getBucketMap().keySet());
            bucketNameSet.addAll(((DebugBilinearMapImpl)this.bilMapTotal.getImpl()).g2.getBucketMap().keySet());
            bucketNameSet.addAll(((DebugBilinearMapImpl)this.bilMapNoExpMultiExp.getImpl()).gt.getBucketMap().keySet());
            bucketNameSet.addAll(((DebugBilinearMapImpl)this.bilMapTotal.getImpl()).gt.getBucketMap().keySet());
            for (String bucketName : bucketNameSet) {
                result.append(this.formatCounterData(bucketName));
            }
        }
        return result.append(this.formatCounterDataAllBucketsOnly()).toString();
    }

    String formatCounterDataAllBucketsOnly() {
        String tab = "    ";
        return "Combined results of all buckets\n" + String.format("%sPairings: %d\n", tab, this.getNumPairingsAllBuckets()) + tab + "G1\n" + ((DebugGroup)this.getG1()).formatCounterDataAllBuckets(true) + tab + "G2\n" + ((DebugGroup)this.getG2()).formatCounterDataAllBuckets(true) + tab + "GT\n" + ((DebugGroup)this.getGT()).formatCounterDataAllBuckets(true);
    }
}

