/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.math.structures.groups.debug;

import java.math.BigInteger;
import java.util.Objects;
import org.cryptimeleon.math.hash.ByteAccumulator;
import org.cryptimeleon.math.serialization.Representation;
import org.cryptimeleon.math.structures.groups.GroupElementImpl;
import org.cryptimeleon.math.structures.groups.GroupImpl;
import org.cryptimeleon.math.structures.groups.debug.DebugGroupImpl;
import org.cryptimeleon.math.structures.rings.zn.Zn;

public class DebugGroupElementImpl
implements GroupElementImpl {
    protected Zn.ZnElement elem;
    protected DebugGroupImpl group;

    public DebugGroupElementImpl(DebugGroupImpl group, Zn.ZnElement elem) {
        this.elem = elem;
        this.group = group;
    }

    @Override
    public GroupImpl getStructure() {
        return this.group;
    }

    @Override
    public GroupElementImpl inv() {
        DebugGroupElementImpl result = this.group.wrap(this.elem.neg());
        this.group.incrementNumInversions();
        return result;
    }

    protected GroupElementImpl op(GroupElementImpl e, boolean count) {
        if (!(e instanceof DebugGroupElementImpl) || !((DebugGroupElementImpl)e).group.equals(this.group)) {
            throw new IllegalArgumentException("Incompatible groups. LHS: " + this.group.name + "(" + this.group.size() + "), RHS: " + (e instanceof DebugGroupElementImpl ? ((DebugGroupElementImpl)e).group.name + "(" + ((DebugGroupElementImpl)e).group.size() + ")" : (e == null ? "null" : e.getStructure())));
        }
        DebugGroupElementImpl result = this.group.wrap(this.elem.add(((DebugGroupElementImpl)e).elem));
        if (count) {
            if (this.equals(e)) {
                this.group.incrementNumSquarings();
            } else {
                this.group.incrementNumOps();
            }
        }
        return result;
    }

    @Override
    public GroupElementImpl op(GroupElementImpl e) throws IllegalArgumentException {
        return this.op(e, true);
    }

    protected GroupElementImpl pow(BigInteger k, boolean count) {
        DebugGroupElementImpl result = this.group.wrap(this.elem.mul(k));
        if (count) {
            this.group.incrementNumExps();
        }
        return result;
    }

    @Override
    public GroupElementImpl pow(BigInteger k) {
        return this.pow(k, true);
    }

    @Override
    public boolean isNeutralElement() {
        return this.elem.isZero();
    }

    public String toString() {
        return this.group.name + "--" + this.elem.toString();
    }

    @Override
    public ByteAccumulator updateAccumulator(ByteAccumulator accumulator) {
        return this.elem.updateAccumulator(accumulator);
    }

    @Override
    public Representation getRepresentation() {
        Representation result = this.elem.getRepresentation();
        this.group.incrementNumRetrievedRepresentations();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DebugGroupElementImpl that = (DebugGroupElementImpl)o;
        return Objects.equals(this.elem, that.elem) && Objects.equals(this.group, that.group);
    }

    public int hashCode() {
        return Objects.hash(this.elem);
    }
}

