/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.math.structures.groups.debug;

import java.math.BigInteger;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.cryptimeleon.math.serialization.Representation;
import org.cryptimeleon.math.serialization.annotations.ReprUtil;
import org.cryptimeleon.math.serialization.annotations.Represented;
import org.cryptimeleon.math.structures.groups.GroupElementImpl;
import org.cryptimeleon.math.structures.groups.GroupImpl;
import org.cryptimeleon.math.structures.groups.debug.CountingBucket;
import org.cryptimeleon.math.structures.groups.debug.DebugGroupElementImpl;
import org.cryptimeleon.math.structures.rings.zn.Zn;

public abstract class DebugGroupImpl
implements GroupImpl {
    @Represented
    protected String name;
    @Represented
    protected Zn zn;

    public DebugGroupImpl(String name, BigInteger n) {
        this.name = name;
        this.zn = new Zn(n);
    }

    public DebugGroupImpl(Representation repr) {
        new ReprUtil(this).deserialize(repr);
    }

    @Override
    public Representation getRepresentation() {
        return ReprUtil.serialize(this);
    }

    @Override
    public GroupElementImpl getNeutralElement() {
        return this.wrap(this.zn.getZeroElement());
    }

    @Override
    public GroupElementImpl getUniformlyRandomElement() throws UnsupportedOperationException {
        return this.wrap(this.zn.getUniformlyRandomElement());
    }

    @Override
    public GroupElementImpl getUniformlyRandomNonNeutral() throws UnsupportedOperationException {
        return this.wrap(this.zn.getUniformlyRandomNonzeroElement());
    }

    @Override
    public GroupElementImpl restoreElement(Representation repr) {
        return this.wrap(this.zn.restoreElement(repr));
    }

    @Override
    public GroupElementImpl getGenerator() throws UnsupportedOperationException {
        return this.wrap(this.zn.getOneElement());
    }

    @Override
    public Optional<Integer> getUniqueByteLength() {
        return this.zn.getUniqueByteLength();
    }

    public int hashCode() {
        return Objects.hash(this.name, this.zn);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DebugGroupImpl)) {
            return false;
        }
        DebugGroupImpl that = (DebugGroupImpl)other;
        return Objects.equals(this.name, that.name) && Objects.equals(this.zn, that.zn);
    }

    public String toString() {
        return this.getClass().getSimpleName() + String.format("(name=%s, Zn=%s)", this.name, this.zn);
    }

    @Override
    public boolean isCommutative() {
        return true;
    }

    @Override
    public BigInteger size() throws UnsupportedOperationException {
        return this.zn.size();
    }

    @Override
    public boolean hasPrimeSize() throws UnsupportedOperationException {
        return this.zn.hasPrimeSize();
    }

    public DebugGroupElementImpl wrap(Zn.ZnElement elem) {
        return new DebugGroupElementImpl(this, elem);
    }

    @Override
    public double estimateCostInvPerOp() {
        return 1.6;
    }

    void incrementNumOps() {
        this.getCurrentBucket().incrementNumOps();
        this.getAllBucketsBucket().incrementNumOps();
    }

    void incrementNumInversions() {
        this.getCurrentBucket().incrementNumInversions();
        this.getAllBucketsBucket().incrementNumInversions();
    }

    void incrementNumSquarings() {
        this.getCurrentBucket().incrementNumSquarings();
        this.getAllBucketsBucket().incrementNumSquarings();
    }

    void incrementNumExps() {
        this.getCurrentBucket().incrementNumExps();
        this.getAllBucketsBucket().incrementNumExps();
    }

    void addMultiExpBaseNumber(int numTerms) {
        this.getCurrentBucket().addMultiExpBaseNumber(numTerms);
        this.getAllBucketsBucket().addMultiExpBaseNumber(numTerms);
    }

    void incrementNumRetrievedRepresentations() {
        this.getCurrentBucket().incrementNumRetrievedRepresentations();
        this.getAllBucketsBucket().incrementNumRetrievedRepresentations();
    }

    long getNumOps(String bucketName) {
        return this.putBucketIfAbsent(bucketName).getNumOps();
    }

    long getNumInversions(String bucketName) {
        return this.putBucketIfAbsent(bucketName).getNumInversions();
    }

    long getNumSquarings(String bucketName) {
        return this.putBucketIfAbsent(bucketName).getNumSquarings();
    }

    long getNumExps(String bucketName) {
        return this.putBucketIfAbsent(bucketName).getNumExps();
    }

    List<Integer> getMultiExpTermNumbers(String bucketName) {
        return this.putBucketIfAbsent(bucketName).getMultiExpTermNumbers();
    }

    long getNumRetrievedRepresentations(String bucketName) {
        return this.putBucketIfAbsent(bucketName).getNumRetrievedRepresentations();
    }

    long getNumOps() {
        return this.getDefaultBucket().getNumOps();
    }

    long getNumInversions() {
        return this.getDefaultBucket().getNumInversions();
    }

    long getNumSquarings() {
        return this.getDefaultBucket().getNumSquarings();
    }

    long getNumExps() {
        return this.getDefaultBucket().getNumExps();
    }

    List<Integer> getMultiExpTermNumbers() {
        return this.getDefaultBucket().getMultiExpTermNumbers();
    }

    long getNumRetrievedRepresentations() {
        return this.getDefaultBucket().getNumRetrievedRepresentations();
    }

    long getNumOpsAllBuckets() {
        return this.getAllBucketsBucket().getNumOps();
    }

    long getNumInversionsAllBuckets() {
        return this.getAllBucketsBucket().getNumInversions();
    }

    long getNumSquaringsAllBuckets() {
        return this.getAllBucketsBucket().getNumSquarings();
    }

    long getNumExpsAllBuckets() {
        return this.getAllBucketsBucket().getNumExps();
    }

    List<Integer> getMultiExpTermNumbersAllBuckets() {
        return this.getAllBucketsBucket().getMultiExpTermNumbers();
    }

    long getNumRetrievedRepresentationsAllBuckets() {
        return this.getAllBucketsBucket().getNumRetrievedRepresentations();
    }

    void resetCounters(String bucketName) {
        this.putBucketIfAbsent(bucketName).resetCounters();
    }

    void resetCounters() {
        this.getDefaultBucket().resetCounters();
    }

    void resetCountersAllBuckets() {
        this.resetCounters();
        this.getBucketMap().forEach((name, bucket) -> bucket.resetCounters());
    }

    CountingBucket getAllBucketsBucket() {
        CountingBucket allBucketsBucket = new CountingBucket();
        allBucketsBucket.numExps.addAndGet(this.getNumExps());
        allBucketsBucket.numInversions.addAndGet(this.getNumInversions());
        allBucketsBucket.numOps.addAndGet(this.getNumOps());
        allBucketsBucket.numSquarings.addAndGet(this.getNumSquarings());
        allBucketsBucket.numRetrievedRepresentations.addAndGet(this.getNumRetrievedRepresentations());
        allBucketsBucket.addAllMultiExpBaseNumbers(this.getMultiExpTermNumbers());
        for (String bucketName : this.getBucketMap().keySet()) {
            allBucketsBucket.numExps.addAndGet(this.getNumExps(bucketName));
            allBucketsBucket.numInversions.addAndGet(this.getNumInversions(bucketName));
            allBucketsBucket.numOps.addAndGet(this.getNumOps(bucketName));
            allBucketsBucket.numSquarings.addAndGet(this.getNumSquarings(bucketName));
            allBucketsBucket.numRetrievedRepresentations.addAndGet(this.getNumRetrievedRepresentations(bucketName));
            allBucketsBucket.addAllMultiExpBaseNumbers(this.getMultiExpTermNumbers(bucketName));
        }
        return allBucketsBucket;
    }

    abstract void setBucket(String var1);

    abstract void setDefaultBucket();

    abstract CountingBucket putBucketIfAbsent(String var1);

    abstract CountingBucket getCurrentBucket();

    abstract CountingBucket getDefaultBucket();

    abstract Map<String, CountingBucket> getBucketMap();
}

