/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.math.structures.groups.debug;

import java.math.BigInteger;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.cryptimeleon.math.serialization.Representation;
import org.cryptimeleon.math.structures.groups.debug.CountingBucket;
import org.cryptimeleon.math.structures.groups.debug.DebugGroupImplNoExpMultiExp;

public class DebugGroupImplGTNoExpMultiExp
extends DebugGroupImplNoExpMultiExp {
    private static final ConcurrentHashMap<String, CountingBucket> countingBucketMap = new ConcurrentHashMap();
    private static final CountingBucket defaultBucket;
    private static volatile CountingBucket currentBucket;

    public DebugGroupImplGTNoExpMultiExp(String name, BigInteger n) {
        super(name, n);
    }

    public DebugGroupImplGTNoExpMultiExp(Representation repr) {
        super(repr);
    }

    @Override
    void setBucket(String name) {
        currentBucket = this.putBucketIfAbsent(name);
    }

    @Override
    void setDefaultBucket() {
        currentBucket = this.getDefaultBucket();
    }

    @Override
    CountingBucket putBucketIfAbsent(String name) {
        return this.getBucketMap().computeIfAbsent(name, kName -> new CountingBucket());
    }

    @Override
    CountingBucket getCurrentBucket() {
        return currentBucket;
    }

    @Override
    CountingBucket getDefaultBucket() {
        return defaultBucket;
    }

    @Override
    Map<String, CountingBucket> getBucketMap() {
        return countingBucketMap;
    }

    static {
        currentBucket = defaultBucket = new CountingBucket();
    }
}

