/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.math.structures.groups.elliptic;

import java.math.BigInteger;
import java.util.Objects;
import java.util.Optional;
import org.cryptimeleon.math.serialization.BigIntegerRepresentation;
import org.cryptimeleon.math.serialization.ObjectRepresentation;
import org.cryptimeleon.math.serialization.Representable;
import org.cryptimeleon.math.serialization.Representation;
import org.cryptimeleon.math.structures.groups.GroupImpl;
import org.cryptimeleon.math.structures.groups.elliptic.PairingTargetGroupElementImpl;
import org.cryptimeleon.math.structures.rings.FieldElement;
import org.cryptimeleon.math.structures.rings.extfield.ExtensionField;
import org.cryptimeleon.math.structures.rings.extfield.ExtensionFieldElement;
import org.cryptimeleon.math.structures.rings.zn.Zp;

public abstract class PairingTargetGroupImpl
implements GroupImpl,
Representable {
    protected ExtensionField fieldOfDefinition;
    protected BigInteger size;
    private PairingTargetGroupElementImpl generator = null;

    public ExtensionField getFieldOfDefinition() {
        return this.fieldOfDefinition;
    }

    public PairingTargetGroupImpl(ExtensionField f, BigInteger size) {
        if (!f.size().subtract(BigInteger.ONE).mod(size).equals(BigInteger.ZERO)) {
            throw new IllegalArgumentException("Size of subgroup has to divide size of field");
        }
        if (!size.isProbablePrime(100)) {
            throw new IllegalArgumentException("Expect prime size");
        }
        this.fieldOfDefinition = f;
        this.size = size;
    }

    public BigInteger getCofactor() {
        return this.fieldOfDefinition.size().divide(this.size());
    }

    @Override
    public BigInteger size() throws UnsupportedOperationException {
        return this.size;
    }

    @Override
    public Representation getRepresentation() {
        ObjectRepresentation r = new ObjectRepresentation();
        r.put("field", this.getFieldOfDefinition().getRepresentation());
        r.put("size", new BigIntegerRepresentation(this.size()));
        return r;
    }

    protected void init(Representation r) {
    }

    public PairingTargetGroupImpl(Representation r) {
        this(new ExtensionField(r.obj().get("field")), r.obj().get("size").bigInt().get());
    }

    @Override
    public PairingTargetGroupElementImpl getNeutralElement() {
        return this.getElement(this.fieldOfDefinition.getOneElement());
    }

    @Override
    public PairingTargetGroupElementImpl getUniformlyRandomElement() throws UnsupportedOperationException {
        return (PairingTargetGroupElementImpl)this.getGenerator().pow(new Zp(this.size()).getUniformlyRandomElement().asInteger());
    }

    @Override
    public PairingTargetGroupElementImpl getGenerator() {
        if (this.generator == null) {
            FieldElement fe;
            do {
                fe = this.getFieldOfDefinition().getUniformlyRandomElement();
            } while ((fe = fe.pow(this.getFieldOfDefinition().size().subtract(BigInteger.ONE).divide(this.size()))).isOne());
            this.generator = this.getElement((ExtensionFieldElement)fe);
        }
        return this.generator;
    }

    @Override
    public PairingTargetGroupElementImpl restoreElement(Representation repr) {
        return this.getElement(this.fieldOfDefinition.restoreElement(repr));
    }

    public abstract PairingTargetGroupElementImpl getElement(ExtensionFieldElement var1);

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PairingTargetGroupImpl that = (PairingTargetGroupImpl)o;
        return this.fieldOfDefinition.equals(that.fieldOfDefinition) && this.size.equals(that.size);
    }

    public int hashCode() {
        return Objects.hash(this.size);
    }

    public String toString() {
        return "Multiplicative subgroup of " + this.getFieldOfDefinition();
    }

    @Override
    public Optional<Integer> getUniqueByteLength() {
        return this.fieldOfDefinition.getUniqueByteLength();
    }

    @Override
    public boolean isCommutative() {
        return true;
    }
}

