/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.math.structures.rings.helpers;

import java.math.BigInteger;
import org.cryptimeleon.math.structures.rings.Field;
import org.cryptimeleon.math.structures.rings.FieldElement;

public abstract class FiniteFieldTools {
    public static boolean isSquare(FieldElement x) {
        if (x.isZero()) {
            return true;
        }
        if (x.getStructure().getCharacteristic().equals(BigInteger.valueOf(2L))) {
            throw new UnsupportedOperationException();
        }
        return x.pow(x.getStructure().sizeUnitGroup().divide(new BigInteger("2"))).isOne();
    }

    public static FieldElement sqrt(FieldElement element) {
        if (!FiniteFieldTools.isSquare(element)) {
            throw new ArithmeticException(element + "is not a square");
        }
        if (element.isZero()) {
            return element;
        }
        Field field = element.getStructure();
        BigInteger q = field.sizeUnitGroup();
        FieldElement z = field.getOneElement();
        while (FiniteFieldTools.isSquare(z = field.getUniformlyRandomElement()) || z.isZero()) {
        }
        int s = 0;
        while (!q.testBit(0)) {
            q = q.shiftRight(1);
            ++s;
        }
        z = z.pow(q);
        FieldElement r = element.pow(q.add(BigInteger.valueOf(1L)).divide(BigInteger.valueOf(2L)));
        FieldElement t = element.pow(q);
        int m = s;
        while (!t.isOne()) {
            int i = 0;
            FieldElement t_squared = t;
            while (!t_squared.isOne()) {
                ++i;
                t_squared = t_squared.mul(t_squared);
            }
            FieldElement b = z;
            for (int j = 0; j < m - i - 1; ++j) {
                b = b.mul(b);
            }
            r = r.mul(b);
            b = b.mul(b);
            t = t.mul(b);
            z = b;
            m = i;
        }
        return r;
    }
}

