/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.math.hash.annotations;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.cryptimeleon.math.hash.ByteAccumulator;
import org.cryptimeleon.math.hash.UniqueByteRepresentable;
import org.cryptimeleon.math.hash.annotations.AnnotatedUbrUtil;
import org.cryptimeleon.math.hash.annotations.UniqueByteRepresented;
import org.junit.Assert;
import org.junit.Test;

public class AnnotatedUbrUtilTest {
    @Test
    public void testUniqueness() {
        Testclass a = new Testclass("xy", "z");
        Testclass b = new Testclass("x", "yz");
        Assert.assertNotEquals((Object)a.getUniqueByteRepresentation(), (Object)b.getUniqueByteRepresentation());
        HashMap<String, byte[]> map1 = new HashMap<String, byte[]>();
        map1.put("bla", new byte[]{0, 1, 2, 3});
        map1.put("blubb", new byte[]{0});
        HashMap<String, byte[]> map2 = new HashMap<String, byte[]>();
        map2.put("bla", new byte[]{0, 1, 2, 3, 4});
        map2.put("blubb", new byte[]{0});
        a = new Testclass(map1);
        b = new Testclass(map2);
        Assert.assertNotEquals((Object)a.getUniqueByteRepresentation(), (Object)b.getUniqueByteRepresentation());
        System.out.println(Arrays.toString(a.getUniqueByteRepresentation()));
        System.out.println(Arrays.toString(b.getUniqueByteRepresentation()));
    }

    public class Testclass
    implements UniqueByteRepresentable {
        @UniqueByteRepresented
        ArrayList<String> testlist;
        @UniqueByteRepresented
        HashMap<String, byte[]> testMap;

        public Testclass(String ... testlist) {
            this.testlist = new ArrayList<String>(Arrays.asList(testlist));
        }

        public Testclass(HashMap<String, byte[]> testMap) {
            this.testMap = testMap;
        }

        public ByteAccumulator updateAccumulator(ByteAccumulator accumulator) {
            return AnnotatedUbrUtil.autoAccumulate((ByteAccumulator)accumulator, (Object)this);
        }
    }
}

