/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.math.serialization.standalone;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.cryptimeleon.math.serialization.StandaloneRepresentable;
import org.cryptimeleon.math.serialization.standalone.StandaloneReprSubTest;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.reflections.Reflections;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public abstract class StandaloneReprTest {
    protected static HashSet<Class<? extends StandaloneRepresentable>> testedClasses = new HashSet();
    private final String packageToTest;
    private final Reflections reflection;

    public StandaloneReprTest(String packagePrefixToTest, String ... additionalPackagesToScan) {
        this.packageToTest = packagePrefixToTest;
        String[] allPackages = Arrays.copyOf(additionalPackagesToScan, additionalPackagesToScan.length + 2);
        allPackages[additionalPackagesToScan.length] = packagePrefixToTest;
        allPackages[additionalPackagesToScan.length + 1] = "org.cryptimeleon";
        this.reflection = new Reflections((Object[])allPackages);
    }

    @ParameterizedTest(name="''{0}''")
    @MethodSource(value={"provideStandaloneReprSubTests"})
    public void testStandaloneRepresentables(StandaloneReprSubTest subtest) {
        testedClasses.addAll(subtest.runTests());
    }

    @Test
    public void testStandaloneRepresentablesWithParameterlessConstructors() {
        testedClasses.addAll(new TestForParameterlessConstructorClasses().runTests());
    }

    protected Stream<? extends Arguments> provideStandaloneReprSubTests() {
        return this.reflection.getSubTypesOf(StandaloneReprSubTest.class).stream().filter(clazz -> !clazz.equals(TestForParameterlessConstructorClasses.class)).filter(clazz -> clazz.getPackage().getName().startsWith(this.packageToTest)).map(clazz -> {
            try {
                return (StandaloneReprSubTest)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException e) {
                e.printStackTrace();
                return null;
            }
            catch (InvocationTargetException e) {
                if (e.getCause() instanceof RuntimeException) {
                    throw (RuntimeException)e.getCause();
                }
                throw new RuntimeException("An exception was thrown in the constructor of " + clazz.getSimpleName(), e);
            }
        }).filter(Objects::nonNull).map(xva$0 -> Arguments.of((Object[])new Object[]{xva$0}));
    }

    @AfterAll
    @DisplayName(value="Checking that every StandaloneRepresentable has been tested.")
    public void checkForUntestedClasses() {
        Set classesToTest = this.reflection.getSubTypesOf(StandaloneRepresentable.class);
        classesToTest.removeAll(testedClasses);
        classesToTest.removeIf(c -> c.isInterface() || Modifier.isAbstract(c.getModifiers()) || !c.getPackage().getName().startsWith(this.packageToTest) || !Modifier.isPublic(c.getModifiers()));
        for (Class notTestedClass : classesToTest) {
            System.err.println(notTestedClass.getName() + " implements StandaloneRepresentable but was not tested by StandaloneTest (or the test failed). You need to define a StandaloneReprSubTest for it.");
        }
        Assertions.assertTrue((boolean)classesToTest.isEmpty(), (String)("Missing (or failed) StandaloneRepresentation tests for " + classesToTest.stream().map(Class::getSimpleName).sorted().collect(Collectors.joining(", "))));
    }

    protected class TestForParameterlessConstructorClasses
    extends StandaloneReprSubTest {
        protected TestForParameterlessConstructorClasses() {
        }

        public void testClassesWithTrivialConstructor() {
            StandaloneReprTest.this.reflection.getSubTypesOf(StandaloneRepresentable.class).stream().filter(clazz -> clazz.getPackage().getName().startsWith(StandaloneReprTest.this.packageToTest)).filter(clazz -> Arrays.stream(clazz.getConstructors()).anyMatch(constr -> constr.getParameterCount() == 0)).filter(clazz -> Modifier.isPublic(clazz.getModifiers())).forEach(clazz -> {
                try {
                    this.test((StandaloneRepresentable)clazz.getConstructor(new Class[0]).newInstance(new Object[0]));
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException e) {
                    Assertions.fail((Throwable)e);
                }
                catch (InvocationTargetException e) {
                    Assertions.fail((String)("Exception was thrown during constructor invocation of " + clazz.getSimpleName()), (Throwable)e.getCause());
                }
            });
        }
    }
}

