/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.math.structures;

import java.math.BigInteger;
import org.cryptimeleon.math.random.RandomGenerator;
import org.cryptimeleon.math.structures.groups.GroupElementImpl;
import org.cryptimeleon.math.structures.groups.GroupImpl;
import org.cryptimeleon.math.structures.groups.debug.DebugBilinearGroupImpl;
import org.cryptimeleon.math.structures.groups.elliptic.BilinearGroup;
import org.cryptimeleon.math.structures.groups.exp.ExponentiationAlgorithms;
import org.cryptimeleon.math.structures.groups.exp.MultiExpTerm;
import org.cryptimeleon.math.structures.groups.exp.Multiexponentiation;
import org.cryptimeleon.math.structures.groups.exp.SmallExponentPrecomputation;
import org.junit.Test;
import org.junit.jupiter.api.Assertions;

public class ExpTests {
    @Test
    public void testMultiExpAlgs() {
        DebugBilinearGroupImpl bilGroup = new DebugBilinearGroupImpl(RandomGenerator.getRandomPrime((int)60), BilinearGroup.Type.TYPE_3, false);
        for (int i = 0; i < 10; ++i) {
            Multiexponentiation multiexponentiation = ExpTests.genMultiExp(bilGroup.getG1(), 10);
            System.out.println(multiexponentiation);
            GroupElementImpl naiveResult = ExpTests.naiveEval(multiexponentiation);
            GroupElementImpl slidingResult = ExponentiationAlgorithms.interleavingSlidingWindowMultiExp((Multiexponentiation)multiexponentiation, (int)4);
            GroupElementImpl wNafResult = ExponentiationAlgorithms.interleavingWnafMultiExp((Multiexponentiation)multiexponentiation, (int)4);
            Assertions.assertEquals((Object)naiveResult, (Object)wNafResult);
            Assertions.assertEquals((Object)naiveResult, (Object)slidingResult);
        }
    }

    private static Multiexponentiation genMultiExp(GroupImpl group, int numTerms) {
        Multiexponentiation multiexponentiation = new Multiexponentiation();
        for (int i = 0; i < numTerms; ++i) {
            multiexponentiation.put(new MultiExpTerm(group.getUniformlyRandomNonNeutral(), RandomGenerator.getRandomNumber((BigInteger)BigInteger.valueOf(Integer.MAX_VALUE))));
        }
        return multiexponentiation;
    }

    private static GroupElementImpl naiveEval(Multiexponentiation multiexp) {
        GroupElementImpl result = ((MultiExpTerm)multiexp.getTerms().get(0)).getBase().getStructure().getNeutralElement();
        for (MultiExpTerm term : multiexp.getTerms()) {
            result = result.op(term.getBase().pow(term.getExponent()));
        }
        return result;
    }

    @Test
    public void testExpAlgs() {
        DebugBilinearGroupImpl bilGroup = new DebugBilinearGroupImpl(RandomGenerator.getRandomPrime((int)128), BilinearGroup.Type.TYPE_3, false);
        for (int i = 0; i < 4; ++i) {
            GroupElementImpl elem = bilGroup.getG1().getUniformlyRandomNonNeutral();
            BigInteger exponent = RandomGenerator.getRandomNumber((BigInteger)BigInteger.valueOf(Integer.MAX_VALUE));
            GroupElementImpl naiveResult = ExponentiationAlgorithms.binSquareMultiplyExp((GroupElementImpl)elem, (BigInteger)exponent);
            GroupElementImpl slidingResult = ExponentiationAlgorithms.slidingWindowExp((GroupElementImpl)elem, (BigInteger)exponent, (SmallExponentPrecomputation)new SmallExponentPrecomputation(elem), (int)4);
            GroupElementImpl wNafResult = ExponentiationAlgorithms.wnafExp((GroupElementImpl)elem, (BigInteger)exponent, (SmallExponentPrecomputation)new SmallExponentPrecomputation(elem), (int)4);
            Assertions.assertEquals((Object)naiveResult, (Object)slidingResult);
            Assertions.assertEquals((Object)naiveResult, (Object)wNafResult);
        }
    }
}

