/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.math.structures;

import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.cryptimeleon.math.random.RandomGenerator;
import org.cryptimeleon.math.structures.Element;
import org.cryptimeleon.math.structures.rings.Ring;
import org.cryptimeleon.math.structures.rings.RingElement;
import org.cryptimeleon.math.structures.rings.polynomial.PolynomialRing;
import org.cryptimeleon.math.structures.rings.zn.Zp;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class PolynomialInterpolationTest {
    @Rule
    public final ExpectedException exception = ExpectedException.none();
    private static final int RING_SIZE = 10;
    private Ring ring;

    @Before
    public void setup() {
        this.ring = new Zp(RandomGenerator.getRandomPrime((int)10));
    }

    @Test
    public void testPolynomialWithRandomCoefficients() {
        int degree = RandomGenerator.getRandomNumber((int)5, (int)10);
        Object[] coefficients = (RingElement[])Stream.generate(() -> ((Ring)this.ring).getUniformlyRandomElement()).distinct().limit(degree + 1).toArray(RingElement[]::new);
        PolynomialRing.Polynomial polynomial = PolynomialRing.getPoly((RingElement[])coefficients);
        Map dataPoints = Stream.generate(() -> ((Ring)this.ring).getUniformlyRandomElement()).distinct().limit(degree + 1).collect(Collectors.toMap(Function.identity(), arg_0 -> ((PolynomialRing.Polynomial)polynomial).evaluate(arg_0)));
        PolynomialRing.Polynomial interpolatedPoly = PolynomialRing.getPoly(dataPoints, (int)degree);
        for (Map.Entry dataPoint : dataPoints.entrySet()) {
            Assert.assertEquals((Object)dataPoint.getValue(), (Object)interpolatedPoly.evaluate((Element)dataPoint.getKey()));
        }
        Assert.assertArrayEquals((Object[])coefficients, (Object[])interpolatedPoly.getCoefficients());
        Assert.assertEquals((Object)polynomial, (Object)interpolatedPoly);
    }

    @Test
    public void testInterpolationExceptionHandling() {
        this.exception.expect(IllegalArgumentException.class);
        PolynomialRing.getPoly(null, (int)0);
        this.exception.expect(IllegalArgumentException.class);
        PolynomialRing.getPoly(Collections.emptyMap(), (int)0);
        Map dataPoints = Stream.generate(() -> ((Ring)this.ring).getUniformlyRandomElement()).distinct().limit(1L).collect(Collectors.toMap(Function.identity(), Function.identity()));
        this.exception.expect(IllegalArgumentException.class);
        PolynomialRing.getPoly(dataPoints, (int)0);
        this.exception.expect(IllegalArgumentException.class);
        PolynomialRing.getPoly(dataPoints, (int)-1);
    }
}

