/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.math.expressions.group;

import java.math.BigInteger;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import org.cryptimeleon.math.expressions.Expression;
import org.cryptimeleon.math.expressions.Substitution;
import org.cryptimeleon.math.expressions.exponent.ExponentExpr;
import org.cryptimeleon.math.expressions.group.AbstractGroupElementExpression;
import org.cryptimeleon.math.expressions.group.GroupElementExpression;
import org.cryptimeleon.math.expressions.group.GroupEmptyExpr;
import org.cryptimeleon.math.expressions.group.GroupOpExpr;
import org.cryptimeleon.math.structures.groups.GroupElement;
import org.cryptimeleon.math.structures.rings.zn.Zn;

public class GroupElementConstantExpr
extends AbstractGroupElementExpression {
    protected final GroupElement value;

    public GroupElementConstantExpr(@Nonnull GroupElement value) {
        super(value.getStructure());
        this.value = value;
    }

    @Override
    public GroupElement evaluate() {
        return this.value;
    }

    @Override
    public GroupElement evaluate(Substitution substitutions) {
        return this.value;
    }

    @Override
    public GroupElementExpression substitute(Substitution substitutions) {
        return this;
    }

    @Override
    public GroupOpExpr linearize() throws IllegalArgumentException {
        return new GroupOpExpr(this, new GroupEmptyExpr(this.value.getStructure()));
    }

    @Override
    public GroupOpExpr flatten(ExponentExpr exponent) {
        if (exponent.containsVariables()) {
            return new GroupOpExpr(new GroupEmptyExpr(this.getGroup()), this.pow(exponent));
        }
        BigInteger groupSize = this.getGroupOrderIfKnown();
        if (groupSize == null) {
            return new GroupOpExpr(this.value.pow(exponent.evaluate()).expr(), new GroupEmptyExpr(this.getGroup()));
        }
        return new GroupOpExpr(this.value.pow(exponent.evaluate(new Zn(groupSize))).expr(), new GroupEmptyExpr(this.getGroup()));
    }

    @Override
    public void forEachChild(Consumer<Expression> action) {
    }
}

