/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.math.expressions.group;

import java.math.BigInteger;
import java.util.function.Consumer;
import org.cryptimeleon.math.expressions.Expression;
import org.cryptimeleon.math.expressions.Substitution;
import org.cryptimeleon.math.expressions.exponent.ExponentExpr;
import org.cryptimeleon.math.expressions.group.AbstractGroupElementExpression;
import org.cryptimeleon.math.expressions.group.GroupElementExpression;
import org.cryptimeleon.math.expressions.group.GroupEmptyExpr;
import org.cryptimeleon.math.expressions.group.GroupOpExpr;
import org.cryptimeleon.math.structures.groups.GroupElement;
import org.cryptimeleon.math.structures.groups.elliptic.BilinearMap;
import org.cryptimeleon.math.structures.rings.zn.Zn;

public class PairingExpr
extends AbstractGroupElementExpression {
    protected GroupElementExpression lhs;
    protected GroupElementExpression rhs;
    protected BilinearMap map;

    public PairingExpr(BilinearMap map, GroupElementExpression lhs, GroupElementExpression rhs) {
        super(map.getGT());
        this.map = map;
        this.lhs = lhs;
        this.rhs = rhs;
    }

    public BilinearMap getMap() {
        return this.map;
    }

    public GroupElementExpression getLhs() {
        return this.lhs;
    }

    public GroupElementExpression getRhs() {
        return this.rhs;
    }

    @Override
    public void forEachChild(Consumer<Expression> action) {
        action.accept(this.lhs);
        action.accept(this.rhs);
    }

    @Override
    public GroupElement evaluate(Substitution substitutions) {
        return this.map.apply(this.lhs.evaluate(substitutions), this.rhs.evaluate(substitutions));
    }

    @Override
    public PairingExpr substitute(Substitution substitutions) {
        return new PairingExpr(this.map, this.lhs.substitute(substitutions), this.rhs.substitute(substitutions));
    }

    @Override
    public GroupOpExpr linearize() throws IllegalArgumentException {
        boolean lhsHasVariables = this.lhs.containsVariables();
        boolean rhsHasVariables = this.rhs.containsVariables();
        if (lhsHasVariables && rhsHasVariables) {
            throw new IllegalArgumentException("Expression is not linear (it's of the form e(g,h), where both g and h depend on variables)");
        }
        if (!lhsHasVariables && !rhsHasVariables) {
            return new GroupOpExpr(this, new GroupEmptyExpr(this.map.getGT()));
        }
        if (lhsHasVariables) {
            GroupOpExpr lhsLinearized = this.lhs.linearize();
            if (lhsLinearized.getLhs() instanceof GroupEmptyExpr) {
                return new GroupOpExpr(new GroupEmptyExpr(this.map.getGT()), this);
            }
            return new GroupOpExpr(new PairingExpr(this.map, lhsLinearized.getLhs(), this.rhs), new PairingExpr(this.map, lhsLinearized.getRhs(), this.rhs));
        }
        GroupOpExpr rhsLinearized = this.rhs.linearize();
        if (rhsLinearized.getLhs() instanceof GroupEmptyExpr) {
            return new GroupOpExpr(new GroupEmptyExpr(this.map.getGT()), this);
        }
        return new GroupOpExpr(new PairingExpr(this.map, this.lhs, rhsLinearized.getLhs()), new PairingExpr(this.map, this.lhs, rhsLinearized.getRhs()));
    }

    @Override
    public GroupOpExpr flatten(ExponentExpr exponent) {
        if (exponent.containsVariables() || this.lhs.containsVariables() || this.rhs.containsVariables()) {
            return new GroupOpExpr(new GroupEmptyExpr(this.map.getGT()), new PairingExpr(this.map, this.lhs.flatten(exponent), this.rhs.flatten()).pow(exponent));
        }
        BigInteger groupSize = this.getGroupOrderIfKnown();
        BigInteger exponentVal = groupSize == null ? exponent.evaluate() : exponent.evaluate(new Zn(groupSize)).asInteger();
        return new GroupOpExpr(this.evaluate().pow(exponentVal).expr(), new GroupEmptyExpr(this.map.getGT()));
    }
}

