/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.math.serialization;

import java.math.BigInteger;
import java.util.Objects;
import org.cryptimeleon.math.serialization.Representation;

public class BigIntegerRepresentation
extends Representation {
    private static final long serialVersionUID = 1243544762886909652L;
    protected BigInteger n;

    public BigIntegerRepresentation() {
    }

    public BigIntegerRepresentation(BigInteger n) {
        this.n = n;
    }

    public BigIntegerRepresentation(int n) {
        this.n = BigInteger.valueOf(n);
    }

    public BigInteger get() {
        return this.n;
    }

    public int getInt() {
        return this.n.intValue();
    }

    public String toString() {
        return this.n.toString();
    }

    public int hashCode() {
        return this.n == null ? 0 : this.n.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BigIntegerRepresentation other = (BigIntegerRepresentation)obj;
        return Objects.equals(this.n, other.n);
    }
}

