/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.math.serialization;

import java.util.Arrays;
import java.util.Base64;
import org.cryptimeleon.math.serialization.Representation;

public class ByteArrayRepresentation
extends Representation {
    private static final long serialVersionUID = 5386237030968264355L;
    protected byte[] data;

    public ByteArrayRepresentation() {
    }

    public ByteArrayRepresentation(byte[] data) {
        this.data = Arrays.copyOf(data, data.length);
    }

    public byte[] get() {
        return this.data;
    }

    public String toString() {
        return Base64.getEncoder().encodeToString(this.data);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.data);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ByteArrayRepresentation other = (ByteArrayRepresentation)obj;
        return Arrays.equals(this.data, other.data);
    }
}

