/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.math.serialization;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.cryptimeleon.math.serialization.Representation;
import org.cryptimeleon.math.serialization.converter.JSONConverter;

public class ObjectRepresentation
extends Representation
implements Iterable<Map.Entry<String, Representation>> {
    private static final long serialVersionUID = -7955738062171729317L;
    protected final Map<String, Representation> map = new HashMap<String, Representation>();

    public ObjectRepresentation() {
    }

    public ObjectRepresentation(String key0, Representation value0) {
        this();
        this.put(key0, value0);
    }

    public ObjectRepresentation(String key0, Representation value0, String key1, Representation value1) {
        this();
        this.put(key0, value0);
        this.put(key1, value1);
    }

    public ObjectRepresentation(String key0, Representation value0, String key1, Representation value1, String key2, Representation value2) {
        this();
        this.put(key0, value0);
        this.put(key1, value1);
        this.put(key2, value2);
    }

    public ObjectRepresentation(String key0, Representation value0, String key1, Representation value1, String key2, Representation value2, String key3, Representation value3) {
        this();
        this.put(key0, value0);
        this.put(key1, value1);
        this.put(key2, value2);
        this.put(key3, value3);
    }

    public void put(String key, Representation value) {
        if (key == null || key.isEmpty()) {
            throw new RuntimeException("Cannot use empty or null keys");
        }
        this.map.put(key, value);
    }

    public Representation putIfMissing(String key, Supplier<Representation> generatorOfValueToPut) {
        return this.map.computeIfAbsent(key, k -> (Representation)generatorOfValueToPut.get());
    }

    public Representation get(String name) {
        return this.map.get(name);
    }

    public Map<String, Representation> getMap() {
        return Collections.unmodifiableMap(this.map);
    }

    @Override
    public Iterator<Map.Entry<String, Representation>> iterator() {
        return this.map.entrySet().stream().sorted(Comparator.comparing(Map.Entry::getKey)).iterator();
    }

    public Stream<Map.Entry<String, Representation>> stream() {
        return this.map.entrySet().stream();
    }

    public void forEach(BiConsumer<String, Representation> consumer) {
        for (Map.Entry<String, Representation> e : this.getMap().entrySet()) {
            consumer.accept(e.getKey(), e.getValue());
        }
    }

    public void forEachOrderedByKeys(BiConsumer<String, Representation> consumer) {
        this.stream().sorted(Comparator.comparing(Map.Entry::getKey)).forEachOrdered(e -> consumer.accept((String)e.getKey(), (Representation)e.getValue()));
    }

    public int size() {
        return this.map.size();
    }

    public String toString() {
        return new JSONConverter().serialize(this);
    }

    public int hashCode() {
        return this.map.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ObjectRepresentation other = (ObjectRepresentation)obj;
        return this.map.equals(other.map);
    }
}

