/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.math.serialization.annotations;

import java.lang.reflect.Type;
import java.util.function.Function;
import org.cryptimeleon.math.serialization.Representable;
import org.cryptimeleon.math.serialization.Representation;
import org.cryptimeleon.math.serialization.annotations.RepresentationHandler;
import org.cryptimeleon.math.serialization.annotations.RepresentationRestorer;

class DependentRepresentationHandler
implements RepresentationHandler {
    protected String restorerString;
    protected Type typeToRestore;

    public DependentRepresentationHandler(String restorerString, Type typeToRestore) {
        this.restorerString = restorerString;
        this.typeToRestore = typeToRestore;
    }

    public static boolean canHandle(Type type) {
        return type instanceof Class && Representable.class.isAssignableFrom((Class)type);
    }

    @Override
    public Object deserializeFromRepresentation(Representation repr, Function<String, RepresentationRestorer> getRegisteredRestorer) {
        if (repr == null) {
            return null;
        }
        return getRegisteredRestorer.apply(this.restorerString).restoreFromRepresentation(this.typeToRestore, repr);
    }

    @Override
    public Representation serializeToRepresentation(Object object) {
        if (object == null) {
            return null;
        }
        return ((Representable)object).getRepresentation();
    }
}

