/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.math.serialization.annotations;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.cryptimeleon.math.serialization.ObjectRepresentation;
import org.cryptimeleon.math.serialization.Representation;
import org.cryptimeleon.math.serialization.annotations.ArrayRepresentationHandler;
import org.cryptimeleon.math.serialization.annotations.CustomRepresentationRestorer;
import org.cryptimeleon.math.serialization.annotations.DependentRepresentationHandler;
import org.cryptimeleon.math.serialization.annotations.ListAndSetRepresentationHandler;
import org.cryptimeleon.math.serialization.annotations.MapRepresentationHandler;
import org.cryptimeleon.math.serialization.annotations.RepresentationHandler;
import org.cryptimeleon.math.serialization.annotations.RepresentationRestorer;
import org.cryptimeleon.math.serialization.annotations.Represented;
import org.cryptimeleon.math.serialization.annotations.StandaloneRepresentationHandler;
import org.cryptimeleon.math.structures.groups.elliptic.BilinearGroup;
import org.cryptimeleon.math.structures.groups.elliptic.BilinearMap;

public class ReprUtil {
    static Pattern methodCallSeparator = Pattern.compile("::");
    protected HashMap<String, RepresentationRestorer> restorers = new HashMap();
    protected Object instance;

    public ReprUtil(Object instance) {
        this.instance = instance;
    }

    public ReprUtil register(RepresentationRestorer restorer, String name) {
        if (this.restorers.containsKey(name)) {
            throw new IllegalArgumentException("Already used name " + name);
        }
        if (Stream.of("->", ",", "[", "]", " ").anyMatch(name::contains)) {
            throw new IllegalArgumentException("Restorer name " + name + " contains reserved chars");
        }
        this.restorers.put(name, restorer);
        return this;
    }

    public ReprUtil register(BilinearGroup bilinearGroup) {
        this.register(bilinearGroup.getBilinearMap());
        return this;
    }

    public ReprUtil register(BilinearMap bilinearMap) {
        this.register(bilinearMap.getG1(), "G1");
        this.register(bilinearMap.getG2(), "G2");
        this.register(bilinearMap.getGT(), "GT");
        return this;
    }

    public ReprUtil register(Function<? super Representation, ?> restorer, String name) {
        return this.register(new CustomRepresentationRestorer(restorer), name);
    }

    private void forEachField(Consumer<Field> fieldConsumer) {
        Class<?> clazz = this.instance.getClass();
        while (!clazz.equals(Object.class)) {
            try {
                Field[] fields;
                for (Field field : fields = clazz.getDeclaredFields()) {
                    if (!ReprUtil.hasRepresentedTypeAnnotation(field)) continue;
                    field.setAccessible(true);
                    fieldConsumer.accept(field);
                }
            }
            catch (IllegalArgumentException | SecurityException e) {
                throw new RuntimeException(e);
            }
            finally {
                clazz = clazz.getSuperclass();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Field getFieldByName(String name) {
        Class<?> clazz = this.instance.getClass();
        while (!clazz.equals(Object.class)) {
            try {
                Field field;
                Field field2 = field = clazz.getDeclaredField(name);
                return field2;
            }
            catch (IllegalArgumentException | SecurityException e) {
                throw new RuntimeException(e);
            }
            catch (NoSuchFieldException noSuchFieldException) {}
            continue;
            finally {
                clazz = clazz.getSuperclass();
            }
        }
        return null;
    }

    public Representation serialize() {
        ObjectRepresentation result = new ObjectRepresentation();
        this.forEachField(field -> {
            try {
                field.setAccessible(true);
                result.put(field.getName(), ReprUtil.getHandler(field.getGenericType(), ReprUtil.getRestorerStringOfField(field)).serializeToRepresentation(field.get(this.instance)));
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        });
        return result;
    }

    public static Representation serialize(Object instance) {
        return new ReprUtil(instance).serialize();
    }

    public static void deserialize(Object instance, Representation repr) {
        new ReprUtil(instance).deserialize(repr);
    }

    public void deserialize(Representation repr) {
        this.forEachField(field -> this.restoreField((Field)field, repr));
    }

    Object restoreField(Field field, Representation topLevelRepr) {
        try {
            field.setAccessible(true);
            Object value = field.get(this.instance);
            if (value != null) {
                return value;
            }
            RepresentationHandler handlerForField = ReprUtil.getHandlerForField(field);
            try {
                value = handlerForField.deserializeFromRepresentation(topLevelRepr.obj().get(field.getName()), name -> this.getOrRecreateRestorer((String)name, topLevelRepr));
            }
            catch (RuntimeException e) {
                throw new RuntimeException("An exception was thrown while restoring " + field.getType().getSimpleName() + " " + field.getName() + " in " + this.instance.getClass().getSimpleName(), e);
            }
            field.set(this.instance, value);
            return value;
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    RepresentationRestorer getOrRecreateRestorer(String restorerString, Representation topLevelRepr) {
        String[] parsed = methodCallSeparator.split(restorerString);
        String baseName = parsed[0];
        if (this.restorers.containsKey(baseName)) {
            return this.restorers.get(baseName);
        }
        Field field = this.getFieldByName(baseName);
        if (field == null) {
            throw new IllegalArgumentException("\"" + baseName + "\" is neither the name of a restorer given through ReprUtil.register, nor is it a member of the class being recreated.");
        }
        Object restoredBase = this.restoreField(field, topLevelRepr);
        if (restoredBase == null) {
            throw new NullPointerException("The member \"" + baseName + "\" is null and hence cannot be used to recreate further objects from representation");
        }
        return ReprUtil.callMethods(restoredBase, parsed);
    }

    private static RepresentationRestorer callMethods(Object baseObject, String[] parsedRestorerString) {
        Object currentObject = baseObject;
        for (int i = 1; i < parsedRestorerString.length; ++i) {
            String methodToCall = parsedRestorerString[i];
            try {
                currentObject = currentObject.getClass().getMethod(methodToCall, new Class[0]).invoke(currentObject, new Object[0]);
                continue;
            }
            catch (IllegalAccessException | NoSuchMethodException e) {
                e.printStackTrace();
                throw new IllegalArgumentException("Cannot call desired method " + methodToCall + " on " + currentObject.getClass().getName(), e);
            }
            catch (InvocationTargetException e) {
                if (e.getCause() instanceof RuntimeException) {
                    throw (RuntimeException)e.getCause();
                }
                throw new RuntimeException("An error occured during invocation of " + methodToCall + " on " + currentObject.getClass(), e);
            }
        }
        if (!(currentObject instanceof RepresentationRestorer)) {
            throw new IllegalArgumentException("\"" + baseObject.getClass().getName() + "\" is not a RepresentationRestorer.");
        }
        return (RepresentationRestorer)currentObject;
    }

    private static boolean hasRepresentedTypeAnnotation(Field field) {
        Annotation[] annotations = field.getDeclaredAnnotations();
        if (annotations == null || annotations.length == 0) {
            return false;
        }
        return Arrays.stream(annotations).map(Annotation::annotationType).anyMatch(a -> a.getSimpleName().startsWith("Represented"));
    }

    private static String getRestorerStringOfField(Field field) {
        Annotation[] annotations = field.getDeclaredAnnotations();
        if (annotations == null || annotations.length == 0) {
            return null;
        }
        for (Annotation annotation : annotations) {
            if (!annotation.annotationType().equals(Represented.class)) continue;
            return ((Represented)annotation).restorer();
        }
        return null;
    }

    protected static RepresentationHandler getHandlerForField(Field field) {
        return ReprUtil.getHandler(field.getGenericType(), ReprUtil.getRestorerStringOfField(field));
    }

    protected static RepresentationHandler getHandler(Type type, String restorerString) {
        if (restorerString == null || restorerString.trim().length() == 0) {
            return ReprUtil.getHandlerWithoutRestorerString(type);
        }
        return ReprUtil.getHandlerWithRestorerString(type, restorerString);
    }

    protected static RepresentationHandler getHandlerWithRestorerString(Type type, String restorerString) {
        if (StandaloneRepresentationHandler.canHandle(type)) {
            return new StandaloneRepresentationHandler((Class)type);
        }
        String trimmedString = ReprUtil.stripEnclosingParentheses(restorerString);
        if (DependentRepresentationHandler.canHandle(type)) {
            return new DependentRepresentationHandler(trimmedString, type);
        }
        if (ListAndSetRepresentationHandler.canHandle(type) && trimmedString.startsWith("[") && trimmedString.endsWith("]")) {
            Type elementType = ListAndSetRepresentationHandler.getElementType(type);
            return new ListAndSetRepresentationHandler(ReprUtil.getHandlerWithRestorerString(elementType, trimmedString.substring(1, trimmedString.length() - 1)), type);
        }
        if (ArrayRepresentationHandler.canHandle(type) && trimmedString.startsWith("[") && trimmedString.endsWith("]")) {
            Class<?> elementType = ArrayRepresentationHandler.getTypeOfElements(type);
            return new ArrayRepresentationHandler(ReprUtil.getHandlerWithRestorerString(elementType, trimmedString.substring(1, trimmedString.length() - 1)), type);
        }
        int mapArrowIndex = ReprUtil.findMapArrow(trimmedString);
        if (MapRepresentationHandler.canHandle(type) && mapArrowIndex != -1) {
            Type keyType = MapRepresentationHandler.getKeyType(type);
            Type valueType = MapRepresentationHandler.getValueType(type);
            return new MapRepresentationHandler(ReprUtil.getHandlerWithRestorerString(keyType, trimmedString.substring(0, mapArrowIndex)), ReprUtil.getHandlerWithRestorerString(valueType, trimmedString.substring(mapArrowIndex + 2)), type);
        }
        throw new IllegalArgumentException("Don't know how to handle type " + type.getTypeName() + " using restorer String \"" + restorerString + "\"");
    }

    protected static RepresentationHandler getHandlerWithoutRestorerString(Type type) {
        Type rawType = type;
        if (type instanceof ParameterizedType) {
            rawType = ((ParameterizedType)type).getRawType();
        }
        if (StandaloneRepresentationHandler.canHandle(rawType)) {
            return new StandaloneRepresentationHandler((Class)rawType);
        }
        if (DependentRepresentationHandler.canHandle(type)) {
            return new DependentRepresentationHandler("", type);
        }
        if (ListAndSetRepresentationHandler.canHandle(type)) {
            Type elementType = ListAndSetRepresentationHandler.getElementType(type);
            return new ListAndSetRepresentationHandler(ReprUtil.getHandlerWithoutRestorerString(elementType), type);
        }
        if (ArrayRepresentationHandler.canHandle(type)) {
            Class<?> elementType = ArrayRepresentationHandler.getTypeOfElements(type);
            return new ArrayRepresentationHandler(ReprUtil.getHandlerWithoutRestorerString(elementType), type);
        }
        if (MapRepresentationHandler.canHandle(type)) {
            Type keyType = MapRepresentationHandler.getKeyType(type);
            Type valueType = MapRepresentationHandler.getValueType(type);
            return new MapRepresentationHandler(ReprUtil.getHandlerWithoutRestorerString(keyType), ReprUtil.getHandlerWithoutRestorerString(valueType), type);
        }
        throw new IllegalArgumentException("Don't know how to handle type " + type.getTypeName() + " using empty restorer String (you can add one within the @Represented annotation)");
    }

    private static int findMapArrow(String str) {
        int depth = 0;
        block5: for (int i = 0; i < str.length(); ++i) {
            switch (str.charAt(i)) {
                case '(': 
                case '[': {
                    ++depth;
                    continue block5;
                }
                case ')': 
                case ']': {
                    --depth;
                    continue block5;
                }
                case '-': {
                    if (depth != 0 || str.length() <= i + 1 || str.charAt(i + 1) != '>') continue block5;
                    return i;
                }
            }
        }
        return -1;
    }

    private static String stripEnclosingParentheses(String str) {
        if (!(str = str.trim()).startsWith("(") || !str.endsWith(")")) {
            return str;
        }
        int depth = 1;
        for (int i = 1; i < str.length() - 1; ++i) {
            switch (str.charAt(i)) {
                case '(': {
                    ++depth;
                    break;
                }
                case ')': {
                    --depth;
                }
            }
            if (depth != 0) continue;
            return str;
        }
        return ReprUtil.stripEnclosingParentheses(str.substring(1, str.length() - 1));
    }
}

