/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.math.serialization.converter;

import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.cryptimeleon.math.misc.BigIntegerTools;
import org.cryptimeleon.math.serialization.BigIntegerRepresentation;
import org.cryptimeleon.math.serialization.ByteArrayRepresentation;
import org.cryptimeleon.math.serialization.ListRepresentation;
import org.cryptimeleon.math.serialization.MapRepresentation;
import org.cryptimeleon.math.serialization.ObjectRepresentation;
import org.cryptimeleon.math.serialization.RepresentableRepresentation;
import org.cryptimeleon.math.serialization.Representation;
import org.cryptimeleon.math.serialization.StringRepresentation;
import org.cryptimeleon.math.serialization.converter.Converter;

public class BinaryFormatConverter
extends Converter<byte[]> {
    protected static final byte TYPE_OBJ = 0;
    protected static final byte TYPE_INT = 1;
    protected static final byte TYPE_INT_INLINE = 2;
    protected static final byte TYPE_STR = 3;
    protected static final byte TYPE_BYTES = 4;
    protected static final byte TYPE_REPR = 5;
    protected static final byte TYPE_LIST = 6;
    protected static final byte TYPE_MAP = 7;
    protected static final byte TYPE_NULL = 8;
    protected final HashMap<String, Integer> well_known_string_indices = new HashMap();
    protected final ArrayList<String> well_known_strings = new ArrayList();

    public BinaryFormatConverter() {
    }

    public BinaryFormatConverter(List<String> well_known_strings, List<Class<?>> well_known_classes) {
        int i = 0;
        for (String string : well_known_strings) {
            this.well_known_string_indices.put(string, i++);
            this.well_known_strings.add(string);
        }
        for (Class clazz : well_known_classes) {
            this.well_known_string_indices.put(clazz.getName(), i++);
            this.well_known_strings.add(clazz.getName());
        }
    }

    @Override
    public byte[] serialize(Representation r) {
        ByteString constants = new ByteString();
        HashMap<String, Integer> stringConstantPos = new HashMap<String, Integer>();
        ByteString structure = this.internalSerialize(r, constants, stringConstantPos);
        int constantLen = constants.len();
        ByteString overall = new ByteString();
        overall.append(constantLen);
        overall.append(constants);
        overall.append(structure);
        byte[] result = new byte[overall.len()];
        overall.writeToByteArray(result, 0);
        return result;
    }

    private ByteString internalSerialize(Representation repr, ByteString constants, HashMap<String, Integer> stringConstantPos) {
        int ptr;
        ByteString structure = new ByteString();
        if (repr == null) {
            structure.append((byte)8);
        }
        if (repr instanceof StringRepresentation) {
            structure.append((byte)3);
            ptr = this.addToConstants(repr.str().get(), constants, stringConstantPos);
            structure.append(ptr);
        }
        if (repr instanceof ByteArrayRepresentation) {
            structure.append((byte)4);
            ptr = this.addToConstants(repr.bytes().get(), constants);
            structure.append(ptr);
        }
        if (repr instanceof BigIntegerRepresentation) {
            BigInteger value2 = repr.bigInt().get();
            try {
                int valueAsInlineInt = BigIntegerTools.getExactInt(value2);
                structure.append((byte)2);
                structure.append(valueAsInlineInt);
            }
            catch (ArithmeticException e) {
                structure.append((byte)1);
                int ptr2 = this.addToConstants(value2.toByteArray(), constants);
                structure.append(ptr2);
            }
        }
        if (repr instanceof RepresentableRepresentation) {
            structure.append((byte)5);
            int ptrClassname = this.addToConstants(repr.repr().getRepresentedTypeName(), constants, stringConstantPos);
            structure.append(ptrClassname);
            ByteString reprBytes = this.internalSerialize(repr.repr().getRepresentation(), constants, stringConstantPos);
            int lenRepr = reprBytes.len();
            structure.append(lenRepr);
            structure.append(reprBytes);
        }
        if (repr instanceof ListRepresentation) {
            structure.append((byte)6);
            for (Representation listItem : repr.list()) {
                ByteString listItemSerialization = this.internalSerialize(listItem, constants, stringConstantPos);
                structure.append(listItemSerialization.len());
                structure.append(listItemSerialization);
            }
        }
        if (repr instanceof ObjectRepresentation) {
            structure.append((byte)0);
            repr.obj().forEachOrderedByKeys((key, value) -> {
                int ptrToKey = this.addToConstants((String)key, constants, stringConstantPos);
                structure.append(ptrToKey);
                ByteString inner = this.internalSerialize((Representation)value, constants, stringConstantPos);
                structure.append(inner.len());
                structure.append(inner);
            });
        }
        if (repr instanceof MapRepresentation) {
            structure.append((byte)7);
            repr.map().forEachRandomlyOrdered((key, value) -> {
                ByteString keySerialized = this.internalSerialize((Representation)key, constants, stringConstantPos);
                structure.append(keySerialized.len());
                structure.append(keySerialized);
                ByteString valueSerialized = this.internalSerialize((Representation)value, constants, stringConstantPos);
                structure.append(valueSerialized.len());
                structure.append(valueSerialized);
            });
        }
        return structure;
    }

    private int addToConstants(String str, ByteString constants, HashMap<String, Integer> stringConstantPos) {
        Integer well_known = this.well_known_string_indices.get(str);
        if (well_known != null) {
            return -well_known.intValue() - 1;
        }
        return stringConstantPos.computeIfAbsent(str, s -> {
            byte[] stringAsBytes = s.getBytes(StandardCharsets.UTF_8);
            return this.addToConstants(stringAsBytes, constants);
        });
    }

    private int addToConstants(byte[] bytes, ByteString constants) {
        int indexWhereConstantIsWrittenTo = constants.len();
        constants.append(bytes.length);
        constants.append(bytes);
        return indexWhereConstantIsWrittenTo;
    }

    private static int byteArrayToInt(byte[] array, int posOfInt) {
        return ByteBuffer.wrap(array).getInt(posOfInt);
    }

    private static byte[] intToByteArray(int val) {
        return ByteBuffer.allocate(4).putInt(val).array();
    }

    @Override
    public Representation deserialize(byte[] data) {
        return this.internalDeserialize(new Input(data));
    }

    private Representation internalDeserialize(Input data) {
        byte type = data.readByte(0);
        if (type == 8) {
            return null;
        }
        if (type == 4) {
            int ptr = data.readInt(1);
            return new ByteArrayRepresentation(data.getByteArrayFromConstants(ptr));
        }
        if (type == 3) {
            int ptr = data.readInt(1);
            return new StringRepresentation(data.getStringFromConstants(ptr));
        }
        if (type == 2) {
            int value = data.readInt(1);
            return new BigIntegerRepresentation(value);
        }
        if (type == 1) {
            int ptr = data.readInt(1);
            return new BigIntegerRepresentation(new BigInteger(data.getByteArrayFromConstants(ptr)));
        }
        if (type == 5) {
            int ptrClassname = data.readInt(1);
            int lenRepr = data.readInt(5);
            return new RepresentableRepresentation(data.getStringFromConstants(ptrClassname), this.internalDeserialize(data.getSubstructureData(9, lenRepr)));
        }
        if (type == 6) {
            int len;
            ListRepresentation result = new ListRepresentation();
            for (int offset = 1; offset < data.len() - 4; offset += 4 + len) {
                len = data.readInt(offset);
                Representation listItem = this.internalDeserialize(data.getSubstructureData(offset + 4, len));
                result.put(listItem);
            }
            return result;
        }
        if (type == 0) {
            int len;
            ObjectRepresentation result = new ObjectRepresentation();
            for (int offset = 1; offset < data.len() - 8; offset += 8 + len) {
                int ptrToKey = data.readInt(offset);
                len = data.readInt(offset + 4);
                Representation value = this.internalDeserialize(data.getSubstructureData(offset + 8, len));
                result.put(data.getStringFromConstants(ptrToKey), value);
            }
            return result;
        }
        if (type == 7) {
            int valueLen;
            MapRepresentation result = new MapRepresentation();
            for (int offset = 1; offset < data.len() - 4; offset += 4 + valueLen) {
                int keyLen = data.readInt(offset);
                Representation key = this.internalDeserialize(data.getSubstructureData(offset + 4, keyLen));
                valueLen = data.readInt(offset += 4 + keyLen);
                Representation value = this.internalDeserialize(data.getSubstructureData(offset + 4, valueLen));
                result.put(key, value);
            }
            return result;
        }
        throw new IllegalArgumentException("Don't know how to deserialize type marked with " + type);
    }

    protected static class ByteString {
        private int len = 0;
        ByteStringListEntry firstPart;
        ByteStringListEntry lastPart = this.firstPart = new ByteStringListEntry(new byte[0]);
        boolean valid = true;

        public void append(ByteString other) {
            if (!this.valid) {
                throw new RuntimeException("Do not re-use ByteStrings that you've already appended to something.");
            }
            this.lastPart.nextPart = other.firstPart;
            this.lastPart = other.lastPart;
            other.valid = false;
            this.len += other.len;
        }

        public void append(byte[] bytes) {
            if (!this.valid) {
                throw new RuntimeException("Do not re-use ByteStrings that you've already appended to something.");
            }
            this.lastPart = this.lastPart.nextPart = new ByteStringListEntry(bytes);
            this.len += bytes.length;
        }

        public void append(byte val) {
            this.append(new byte[]{val});
        }

        public void append(int val) {
            this.append(BinaryFormatConverter.intToByteArray(val));
        }

        public int len() {
            if (!this.valid) {
                throw new RuntimeException("Do not re-use ByteStrings that you've already appended to something.");
            }
            return this.len;
        }

        public void writeToByteArray(Object dest, int pos) {
            this.firstPart.writeToByteArray(dest, pos);
        }

        public String toString() {
            byte[] result = new byte[this.len];
            this.firstPart.writeToByteArray(result, 0);
            return Arrays.toString(result);
        }

        protected static class ByteStringListEntry {
            ByteStringListEntry nextPart;
            final byte[] thisPart;

            public ByteStringListEntry(byte[] bytes) {
                this.thisPart = bytes;
                this.nextPart = null;
            }

            protected void writeToByteArray(Object dest, int pos) {
                if (this.thisPart.length != 0) {
                    System.arraycopy(this.thisPart, 0, dest, pos, this.thisPart.length);
                }
                if (this.nextPart != null) {
                    this.nextPart.writeToByteArray(dest, pos + this.thisPart.length);
                }
            }
        }
    }

    protected class Input {
        private final byte[] data;
        private static final int constantsOffset = 4;
        private final int constantsLen;
        private final int substructureOffset;
        private final int substructureLength;

        public Input(byte[] data) {
            this.data = data;
            this.constantsLen = BinaryFormatConverter.byteArrayToInt(data, 0);
            this.substructureOffset = 4 + this.constantsLen;
            this.substructureLength = data.length - this.substructureOffset;
        }

        private Input(Input input, int structureOffset, int structureLength) {
            this.data = input.data;
            this.constantsLen = input.constantsLen;
            this.substructureOffset = input.substructureOffset + structureOffset;
            this.substructureLength = structureLength;
        }

        public String getStringFromConstants(int ptr) {
            if (ptr < 0) {
                return BinaryFormatConverter.this.well_known_strings.get(-(ptr + 1));
            }
            return new String(this.data, ptr + 4 + 4, BinaryFormatConverter.byteArrayToInt(this.data, ptr + 4), StandardCharsets.UTF_8);
        }

        public byte[] getByteArrayFromConstants(int ptr) {
            return Arrays.copyOfRange(this.data, ptr + 4 + 4, ptr + 4 + 4 + BinaryFormatConverter.byteArrayToInt(this.data, ptr + 4));
        }

        public int readInt(int posInStructure) {
            return BinaryFormatConverter.byteArrayToInt(this.data, this.substructureOffset + posInStructure);
        }

        public byte readByte(int posInStructure) {
            return this.data[this.substructureOffset + posInStructure];
        }

        public Input getSubstructureData(int offset, int length) {
            if (this.substructureLength - offset < length) {
                throw new RuntimeException("Illegal offset or length");
            }
            return new Input(this, offset, length);
        }

        public int len() {
            return this.substructureLength;
        }
    }
}

