/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.math.structures.groups.basic;

import java.math.BigInteger;
import java.util.Objects;
import java.util.Optional;
import org.cryptimeleon.math.serialization.RepresentableRepresentation;
import org.cryptimeleon.math.serialization.Representation;
import org.cryptimeleon.math.structures.groups.Group;
import org.cryptimeleon.math.structures.groups.GroupElement;
import org.cryptimeleon.math.structures.groups.GroupElementImpl;
import org.cryptimeleon.math.structures.groups.GroupImpl;
import org.cryptimeleon.math.structures.groups.basic.BasicGroupElement;
import org.cryptimeleon.math.structures.rings.zn.Zn;
import org.cryptimeleon.math.structures.rings.zn.Zp;

public class BasicGroup
implements Group {
    protected GroupImpl impl;
    protected BigInteger size;
    protected boolean isPrimeOrder;
    protected Zn zn;

    public BasicGroup(GroupImpl impl) {
        this.impl = impl;
        try {
            this.size = impl.size();
            this.isPrimeOrder = this.size.isProbablePrime(100);
            this.zn = this.isPrimeOrder ? new Zp(this.size) : new Zn(this.size);
        }
        catch (UnsupportedOperationException e) {
            this.size = null;
            this.isPrimeOrder = false;
            this.zn = null;
        }
    }

    public BasicGroup(Representation repr) {
        this((GroupImpl)repr.repr().recreateRepresentable());
    }

    protected BasicGroupElement wrap(GroupElementImpl impl) {
        return new BasicGroupElement(this, impl);
    }

    @Override
    public GroupElement getNeutralElement() {
        return this.wrap(this.impl.getNeutralElement());
    }

    @Override
    public BigInteger size() throws UnsupportedOperationException {
        return this.size == null ? this.impl.size() : this.size;
    }

    @Override
    public boolean hasPrimeSize() {
        return this.isPrimeOrder;
    }

    @Override
    public GroupElement getUniformlyRandomElement() throws UnsupportedOperationException {
        return this.wrap(this.impl.getUniformlyRandomElement());
    }

    @Override
    public GroupElement getUniformlyRandomNonNeutral() {
        return this.wrap(this.impl.getUniformlyRandomNonNeutral());
    }

    @Override
    public GroupElement restoreElement(Representation repr) {
        return this.wrap(this.impl.restoreElement(repr));
    }

    @Override
    public GroupElement getGenerator() throws UnsupportedOperationException {
        return this.wrap(this.impl.getGenerator());
    }

    @Override
    public Optional<Integer> getUniqueByteLength() {
        return this.impl.getUniqueByteLength();
    }

    @Override
    public boolean isCommutative() {
        return this.impl.isCommutative();
    }

    @Override
    public Zn getZn() {
        return this.zn;
    }

    @Override
    public Representation getRepresentation() {
        return new RepresentableRepresentation(this.impl);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BasicGroup that = (BasicGroup)o;
        return Objects.equals(this.impl, that.impl);
    }

    public int hashCode() {
        return Objects.hash(this.impl);
    }
}

