/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.math.structures.groups.debug;

import java.math.BigInteger;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.cryptimeleon.math.structures.groups.GroupElementImpl;
import org.cryptimeleon.math.structures.groups.debug.DebugGroupElementImpl;
import org.cryptimeleon.math.structures.groups.debug.DebugGroupImpl;
import org.cryptimeleon.math.structures.groups.debug.DebugGroupImplG1NoExpMultiExp;
import org.cryptimeleon.math.structures.groups.debug.DebugGroupImplG1Total;
import org.cryptimeleon.math.structures.groups.debug.DebugGroupImplG2NoExpMultiExp;
import org.cryptimeleon.math.structures.groups.debug.DebugGroupImplG2Total;
import org.cryptimeleon.math.structures.groups.debug.DebugGroupImplGTNoExpMultiExp;
import org.cryptimeleon.math.structures.groups.debug.DebugGroupImplGTTotal;
import org.cryptimeleon.math.structures.groups.elliptic.BilinearGroup;
import org.cryptimeleon.math.structures.groups.elliptic.BilinearMapImpl;
import org.cryptimeleon.math.structures.rings.zn.Zn;

public class DebugBilinearMapImpl
implements BilinearMapImpl {
    protected DebugGroupImpl g1;
    protected DebugGroupImpl g2;
    protected DebugGroupImpl gt;
    protected Zn zn;
    protected BigInteger size;
    protected BilinearGroup.Type pairingType;
    private static final ConcurrentHashMap<String, PairingCounter> numPairingsMap = new ConcurrentHashMap();
    private static final PairingCounter defaultBucket;
    private static volatile PairingCounter currentBucket;

    public DebugBilinearMapImpl(BigInteger groupSize, BilinearGroup.Type type, boolean enableExpMultiExpCounting) {
        this.size = groupSize;
        this.zn = new Zn(groupSize);
        this.pairingType = type;
        if (enableExpMultiExpCounting) {
            this.g1 = new DebugGroupImplG1NoExpMultiExp("G1", groupSize);
            this.g2 = type == BilinearGroup.Type.TYPE_1 ? new DebugGroupImplG2NoExpMultiExp("G1", groupSize) : new DebugGroupImplG2NoExpMultiExp("G2", groupSize);
            this.gt = new DebugGroupImplGTNoExpMultiExp("GT", groupSize);
        } else {
            this.g1 = new DebugGroupImplG1Total("G1", groupSize);
            this.g2 = type == BilinearGroup.Type.TYPE_1 ? new DebugGroupImplG2Total("G1", groupSize) : new DebugGroupImplG2Total("G2", groupSize);
            this.gt = new DebugGroupImplGTTotal("GT", groupSize);
        }
    }

    @Override
    public GroupElementImpl apply(GroupElementImpl g1, GroupElementImpl g2, BigInteger exponent) {
        return this.apply(g1.pow(exponent), g2);
    }

    @Override
    public GroupElementImpl apply(GroupElementImpl g1, GroupElementImpl g2) {
        if (!(g1 instanceof DebugGroupElementImpl) || !((DebugGroupElementImpl)g1).group.equals(this.g1)) {
            throw new IllegalArgumentException("first pairing argument is not in " + this.g1.name + ". It's in " + (!(g1 instanceof DebugGroupElementImpl) ? g1.getStructure() : (g1 == null ? null : ((DebugGroupElementImpl)g1).group.name)));
        }
        if (!(g2 instanceof DebugGroupElementImpl) || !((DebugGroupElementImpl)g2).group.equals(this.g2)) {
            throw new IllegalArgumentException("first pairing argument is not in " + this.g2.name + ". It's in " + (!(g2 instanceof DebugGroupElementImpl) ? g2.getStructure() : (g2 == null ? null : ((DebugGroupElementImpl)g2).group.name)));
        }
        DebugGroupElementImpl result = this.gt.wrap(((DebugGroupElementImpl)g1).elem.mul(((DebugGroupElementImpl)g2).elem));
        this.incrementNumPairings();
        return result;
    }

    public String toString() {
        return this.getClass().getSimpleName() + String.format("(Zn=%s, pairingType=%s)", new Object[]{this.zn, this.pairingType});
    }

    @Override
    public boolean isSymmetric() {
        return this.pairingType == BilinearGroup.Type.TYPE_1;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DebugBilinearMapImpl that = (DebugBilinearMapImpl)o;
        return this.pairingType == that.pairingType && Objects.equals(this.size, that.size);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.size, this.pairingType});
    }

    void setBucket(String name) {
        currentBucket = this.putBucketIfAbsent(name);
    }

    void setDefaultBucket() {
        currentBucket = defaultBucket;
    }

    PairingCounter putBucketIfAbsent(String name) {
        return numPairingsMap.computeIfAbsent(name, kName -> new PairingCounter());
    }

    ConcurrentHashMap<String, PairingCounter> getBucketMap() {
        return numPairingsMap;
    }

    long getNumPairings(String bucketName) {
        return this.putBucketIfAbsent(bucketName).getNumPairings();
    }

    long getNumPairings() {
        return defaultBucket.getNumPairings();
    }

    long getNumPairingsAllBuckets() {
        return this.getBucketMap().reduceValuesToLong(Long.MAX_VALUE, pc -> ((PairingCounter)pc).count.get(), 0L, Long::sum) + this.getNumPairings();
    }

    void resetNumPairings(String bucketName) {
        this.putBucketIfAbsent(bucketName).count.set(0L);
    }

    void resetNumPairings() {
        defaultBucket.count.set(0L);
    }

    void resetNumPairingsAllBuckets() {
        this.resetNumPairings();
        numPairingsMap.replaceAll((name, numPairings) -> new PairingCounter());
    }

    protected void incrementNumPairings() {
        currentBucket.incNumPairings();
    }

    static {
        currentBucket = defaultBucket = new PairingCounter();
    }

    private static class PairingCounter {
        private final AtomicLong count = new AtomicLong(0L);

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PairingCounter that = (PairingCounter)o;
            return this.count.equals(that.count);
        }

        public int hashCode() {
            return Objects.hash(this.count);
        }

        public void incNumPairings() {
            this.count.incrementAndGet();
        }

        public long getNumPairings() {
            return this.count.get();
        }
    }
}

