/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.math.structures.groups.debug;

import java.math.BigInteger;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.cryptimeleon.math.serialization.Representation;
import org.cryptimeleon.math.serialization.annotations.ReprUtil;
import org.cryptimeleon.math.serialization.annotations.Represented;
import org.cryptimeleon.math.structures.groups.Group;
import org.cryptimeleon.math.structures.groups.GroupElement;
import org.cryptimeleon.math.structures.groups.debug.CountingNamespace;
import org.cryptimeleon.math.structures.groups.debug.DebugGroupElement;
import org.cryptimeleon.math.structures.groups.debug.DebugGroupImpl;
import org.cryptimeleon.math.structures.groups.debug.DebugGroupImplG1NoExpMultiExp;
import org.cryptimeleon.math.structures.groups.debug.DebugGroupImplG1Total;
import org.cryptimeleon.math.structures.groups.debug.DebugGroupImplG2NoExpMultiExp;
import org.cryptimeleon.math.structures.groups.debug.DebugGroupImplG2Total;
import org.cryptimeleon.math.structures.groups.debug.DebugGroupImplGTNoExpMultiExp;
import org.cryptimeleon.math.structures.groups.debug.DebugGroupImplGTTotal;
import org.cryptimeleon.math.structures.groups.debug.DebugGroupImplNoExpMultiExp;
import org.cryptimeleon.math.structures.groups.debug.DebugGroupImplTotal;
import org.cryptimeleon.math.structures.groups.exp.ExpAlgorithm;
import org.cryptimeleon.math.structures.groups.exp.MultiExpAlgorithm;
import org.cryptimeleon.math.structures.groups.lazy.LazyGroup;
import org.cryptimeleon.math.structures.groups.lazy.LazyGroupElement;
import org.cryptimeleon.math.structures.rings.zn.Zn;

public class DebugGroup
implements Group {
    @Represented
    protected LazyGroup groupTotal;
    @Represented
    protected LazyGroup groupNoExpMultiExp;
    @Represented
    protected CountingNamespace countingNamespace;

    public DebugGroup(String name, BigInteger size) {
        this(name, size, CountingNamespace.NO_BILGROUP);
    }

    DebugGroup(String name, BigInteger size, CountingNamespace cntNamespace) {
        this.countingNamespace = cntNamespace;
        switch (this.countingNamespace) {
            case G1: {
                this.groupTotal = new LazyGroup(new DebugGroupImplG1Total(name, size));
                this.groupNoExpMultiExp = new LazyGroup(new DebugGroupImplG1NoExpMultiExp(name, size));
                break;
            }
            case G2: {
                this.groupTotal = new LazyGroup(new DebugGroupImplG2Total(name, size));
                this.groupNoExpMultiExp = new LazyGroup(new DebugGroupImplG2NoExpMultiExp(name, size));
                break;
            }
            case GT: {
                this.groupTotal = new LazyGroup(new DebugGroupImplGTTotal(name, size));
                this.groupNoExpMultiExp = new LazyGroup(new DebugGroupImplGTNoExpMultiExp(name, size));
                break;
            }
            default: {
                this.groupTotal = new LazyGroup(new DebugGroupImplTotal(name, size));
                this.groupNoExpMultiExp = new LazyGroup(new DebugGroupImplNoExpMultiExp(name, size));
            }
        }
    }

    public DebugGroup(String name, long size) {
        this(name, BigInteger.valueOf(size));
    }

    public DebugGroup(LazyGroup groupTotal, LazyGroup groupExpMultiExp) {
        this.groupTotal = groupTotal;
        this.groupNoExpMultiExp = groupExpMultiExp;
        this.countingNamespace = CountingNamespace.NO_BILGROUP;
    }

    public DebugGroup(Representation repr) {
        new ReprUtil(this).deserialize(repr);
    }

    @Override
    public GroupElement getNeutralElement() {
        return new DebugGroupElement(this, (LazyGroupElement)this.groupTotal.getNeutralElement(), (LazyGroupElement)this.groupNoExpMultiExp.getNeutralElement());
    }

    @Override
    public BigInteger size() throws UnsupportedOperationException {
        return this.groupTotal.size();
    }

    @Override
    public Zn getZn() {
        return this.groupTotal.getZn();
    }

    @Override
    public GroupElement getUniformlyRandomElement() throws UnsupportedOperationException {
        return new DebugGroupElement(this, (LazyGroupElement)this.groupTotal.getUniformlyRandomElement(), (LazyGroupElement)this.groupNoExpMultiExp.getUniformlyRandomElement());
    }

    @Override
    public GroupElement restoreElement(Representation repr) {
        return new DebugGroupElement(this, repr);
    }

    public DebugGroupElement wrap(Zn.ZnElement elem) {
        return new DebugGroupElement(this, this.groupTotal.wrap(((DebugGroupImpl)this.groupTotal.getImpl()).wrap(elem)), this.groupNoExpMultiExp.wrap(((DebugGroupImpl)this.groupNoExpMultiExp.getImpl()).wrap(elem)));
    }

    @Override
    public Optional<Integer> getUniqueByteLength() {
        Optional<Integer> totalLength = this.groupTotal.getUniqueByteLength();
        Optional<Integer> expMultiExpLength = this.groupNoExpMultiExp.getUniqueByteLength();
        if (!totalLength.isPresent() || !expMultiExpLength.isPresent()) {
            return Optional.empty();
        }
        return Optional.of(totalLength.get() + expMultiExpLength.get());
    }

    @Override
    public boolean isCommutative() {
        return this.groupTotal.isCommutative();
    }

    @Override
    public Representation getRepresentation() {
        return ReprUtil.serialize(this);
    }

    public void setBucket(String name) {
        ((DebugGroupImpl)this.groupTotal.getImpl()).setBucket(name);
        ((DebugGroupImpl)this.groupNoExpMultiExp.getImpl()).setBucket(name);
    }

    public long getNumSquaringsTotal(String bucketName) {
        return ((DebugGroupImpl)this.groupTotal.getImpl()).getNumSquarings(bucketName);
    }

    public long getNumInversionsTotal(String bucketName) {
        return ((DebugGroupImpl)this.groupTotal.getImpl()).getNumInversions(bucketName);
    }

    public long getNumOpsTotal(String bucketName) {
        return ((DebugGroupImpl)this.groupTotal.getImpl()).getNumOps(bucketName);
    }

    public long getNumSquaringsNoExpMultiExp(String bucketName) {
        return ((DebugGroupImpl)this.groupNoExpMultiExp.getImpl()).getNumSquarings(bucketName);
    }

    public long getNumInversionsNoExpMultiExp(String bucketName) {
        return ((DebugGroupImpl)this.groupNoExpMultiExp.getImpl()).getNumInversions(bucketName);
    }

    public long getNumOpsNoExpMultiExp(String bucketName) {
        return ((DebugGroupImpl)this.groupNoExpMultiExp.getImpl()).getNumOps(bucketName);
    }

    public long getNumExps(String bucketName) {
        return ((DebugGroupImpl)this.groupNoExpMultiExp.getImpl()).getNumExps(bucketName);
    }

    public List<Integer> getMultiExpTermNumbers(String bucketName) {
        return ((DebugGroupImpl)this.groupNoExpMultiExp.getImpl()).getMultiExpTermNumbers(bucketName);
    }

    public long getNumRetrievedRepresentations(String bucketName) {
        return ((DebugGroupImpl)this.groupTotal.getImpl()).getNumRetrievedRepresentations(bucketName);
    }

    public long getNumSquaringsTotal() {
        return ((DebugGroupImpl)this.groupTotal.getImpl()).getNumSquarings();
    }

    public long getNumInversionsTotal() {
        return ((DebugGroupImpl)this.groupTotal.getImpl()).getNumInversions();
    }

    public long getNumOpsTotal() {
        return ((DebugGroupImpl)this.groupTotal.getImpl()).getNumOps();
    }

    public long getNumSquaringsNoExpMultiExp() {
        return ((DebugGroupImpl)this.groupNoExpMultiExp.getImpl()).getNumSquarings();
    }

    public long getNumInversionsNoExpMultiExp() {
        return ((DebugGroupImpl)this.groupNoExpMultiExp.getImpl()).getNumInversions();
    }

    public long getNumOpsNoExpMultiExp() {
        return ((DebugGroupImpl)this.groupNoExpMultiExp.getImpl()).getNumOps();
    }

    public long getNumExps() {
        return ((DebugGroupImpl)this.groupNoExpMultiExp.getImpl()).getNumExps();
    }

    public List<Integer> getMultiExpTermNumbers() {
        return ((DebugGroupImpl)this.groupNoExpMultiExp.getImpl()).getMultiExpTermNumbers();
    }

    public long getNumRetrievedRepresentations() {
        return ((DebugGroupImpl)this.groupTotal.getImpl()).getNumRetrievedRepresentations();
    }

    public long getNumSquaringsTotalAllBuckets() {
        return ((DebugGroupImpl)this.groupTotal.getImpl()).getNumSquaringsAllBuckets();
    }

    public long getNumInversionsTotalAllBuckets() {
        return ((DebugGroupImpl)this.groupTotal.getImpl()).getNumInversionsAllBuckets();
    }

    public long getNumOpsTotalAllBuckets() {
        return ((DebugGroupImpl)this.groupTotal.getImpl()).getNumOpsAllBuckets();
    }

    public long getNumSquaringsNoExpMultiExpAllBuckets() {
        return ((DebugGroupImpl)this.groupNoExpMultiExp.getImpl()).getNumSquaringsAllBuckets();
    }

    public long getNumInversionsNoExpMultiExpAllBuckets() {
        return ((DebugGroupImpl)this.groupNoExpMultiExp.getImpl()).getNumInversionsAllBuckets();
    }

    public long getNumOpsNoExpMultiExpAllBuckets() {
        return ((DebugGroupImpl)this.groupNoExpMultiExp.getImpl()).getNumOpsAllBuckets();
    }

    public long getNumExpsAllBuckets() {
        return ((DebugGroupImpl)this.groupNoExpMultiExp.getImpl()).getNumExpsAllBuckets();
    }

    public List<Integer> getMultiExpTermNumbersAllBuckets() {
        return ((DebugGroupImpl)this.groupNoExpMultiExp.getImpl()).getMultiExpTermNumbersAllBuckets();
    }

    public long getNumRetrievedRepresentationsAllBuckets() {
        return ((DebugGroupImpl)this.groupTotal.getImpl()).getNumRetrievedRepresentationsAllBuckets();
    }

    public void resetCounters(String bucketName) {
        ((DebugGroupImpl)this.groupTotal.getImpl()).resetCounters(bucketName);
        ((DebugGroupImpl)this.groupNoExpMultiExp.getImpl()).resetCounters(bucketName);
    }

    public void resetCounters() {
        ((DebugGroupImpl)this.groupTotal.getImpl()).resetCounters();
        ((DebugGroupImpl)this.groupNoExpMultiExp.getImpl()).resetCounters();
    }

    public void resetCountersAllBuckets() {
        ((DebugGroupImpl)this.groupTotal.getImpl()).resetCountersAllBuckets();
        ((DebugGroupImpl)this.groupNoExpMultiExp.getImpl()).resetCountersAllBuckets();
    }

    public String formatCounterData(String bucketName) {
        return this.formatCounterData(bucketName, false, false);
    }

    public String formatCounterData() {
        return this.formatCounterData("", false, true);
    }

    public String formatCounterDataAllBuckets(boolean summaryOnly) {
        StringBuilder result = new StringBuilder();
        if (!summaryOnly) {
            result.append(this.formatCounterData("", false, true));
            HashSet<String> bucketNames = new HashSet<String>();
            bucketNames.addAll(((DebugGroupImpl)this.groupTotal.getImpl()).getBucketMap().keySet());
            bucketNames.addAll(((DebugGroupImpl)this.groupNoExpMultiExp.getImpl()).getBucketMap().keySet());
            for (String bucketName : bucketNames) {
                result.append(this.formatCounterData(bucketName, false, false));
            }
        }
        return result.append(this.formatCounterDataAllBucketsOnly(false)).toString();
    }

    public String formatCounterDataAllBuckets() {
        return this.formatCounterDataAllBuckets(false);
    }

    String formatCounterData(String bucketName, boolean formatForBilGroup, boolean isDefault) {
        long numExps;
        long numRetrievedReprs;
        List<Integer> multiExpTerms;
        long expMultiExpNumInvs;
        long expMultiExpNumSqs;
        long expMultiExpNumOps;
        long totalNumOpsSqs;
        long totalNumInvs;
        long totalNumSqs;
        long totalNumOps;
        if (isDefault) {
            bucketName = "Default";
            totalNumOps = this.getNumOpsTotal();
            totalNumSqs = this.getNumSquaringsTotal();
            totalNumInvs = this.getNumInversionsTotal();
            totalNumOpsSqs = totalNumOps + totalNumSqs;
            expMultiExpNumOps = totalNumOps - this.getNumOpsNoExpMultiExp();
            expMultiExpNumSqs = totalNumSqs - this.getNumSquaringsNoExpMultiExp();
            expMultiExpNumInvs = totalNumInvs - this.getNumInversionsNoExpMultiExp();
            multiExpTerms = this.getMultiExpTermNumbers();
            numRetrievedReprs = this.getNumRetrievedRepresentations();
            numExps = this.getNumExps();
        } else {
            totalNumOps = this.getNumOpsTotal(bucketName);
            totalNumSqs = this.getNumSquaringsTotal(bucketName);
            totalNumInvs = this.getNumInversionsTotal(bucketName);
            totalNumOpsSqs = totalNumOps + totalNumSqs;
            expMultiExpNumOps = totalNumOps - this.getNumOpsNoExpMultiExp(bucketName);
            expMultiExpNumSqs = totalNumSqs - this.getNumSquaringsNoExpMultiExp(bucketName);
            expMultiExpNumInvs = totalNumInvs - this.getNumInversionsNoExpMultiExp(bucketName);
            multiExpTerms = this.getMultiExpTermNumbers(bucketName);
            numRetrievedReprs = this.getNumRetrievedRepresentations(bucketName);
            numExps = this.getNumExps(bucketName);
        }
        StringBuilder tab = new StringBuilder();
        String tab2 = "    ";
        String result = "";
        if (formatForBilGroup) {
            tab.append("        ");
        } else {
            tab.append("    ");
            result = result + bucketName + "\n";
        }
        return result + String.format("%s(Costly) Operations: %d\n", tab.toString(), totalNumOpsSqs) + String.format("%s%sGroup operations (not squarings): %d (%d of which happened during (multi-)exp)\n", tab.toString(), tab2, totalNumOps, expMultiExpNumOps) + String.format("%s%sSquarings: %d (%d of which happened during (multi-)exp)\n", tab.toString(), tab2, totalNumSqs, expMultiExpNumSqs) + String.format("%sInversions: %d (%d of which happened during (multi-)exp)\n", tab.toString(), totalNumInvs, expMultiExpNumInvs) + String.format("%sExponentiations: %d\n", tab.toString(), numExps) + String.format("%sMulti-exponentiations (number of terms in each): %s\n", tab.toString(), multiExpTerms) + String.format("%sgetRepresentation() calls: %d\n", tab.toString(), numRetrievedReprs);
    }

    String formatCounterDataAllBucketsOnly(boolean formatForBilGroup) {
        long totalNumOps = this.getNumOpsTotalAllBuckets();
        long totalNumSqs = this.getNumSquaringsTotalAllBuckets();
        long totalNumInvs = this.getNumInversionsTotalAllBuckets();
        long totalNumOpsSqs = totalNumOps + totalNumSqs;
        long expMultiExpNumOps = totalNumOps - this.getNumOpsNoExpMultiExpAllBuckets();
        long expMultiExpNumSqs = totalNumSqs - this.getNumSquaringsNoExpMultiExpAllBuckets();
        long expMultiExpNumInvs = totalNumInvs - this.getNumInversionsNoExpMultiExpAllBuckets();
        List<Integer> multiExpTerms = this.getMultiExpTermNumbersAllBuckets();
        StringBuilder tab = new StringBuilder();
        String tab2 = "    ";
        String result = "";
        if (formatForBilGroup) {
            tab.append("        ");
        } else {
            tab.append("    ");
            result = result + "Combined results of all buckets\n";
        }
        return result + String.format("%s(Costly) Operations: %d\n", tab.toString(), totalNumOpsSqs) + String.format("%s%sGroup operations (not squarings): %d (%d of which happened during (multi-)exp)\n", tab.toString(), tab2, totalNumOps, expMultiExpNumOps) + String.format("%s%sSquarings: %d (%d of which happened during (multi-)exp)\n", tab.toString(), tab2, totalNumSqs, expMultiExpNumSqs) + String.format("%sInversions: %d (%d of which happened during (multi-)exp)\n", tab.toString(), totalNumInvs, expMultiExpNumInvs) + String.format("%sExponentiations: %d\n", tab.toString(), this.getNumExpsAllBuckets()) + String.format("%sMulti-exponentiations (number of terms in each): %s\n", tab.toString(), multiExpTerms) + String.format("%sgetRepresentation() calls: %d\n", tab.toString(), this.getNumRetrievedRepresentationsAllBuckets());
    }

    public int getExponentiationWindowSize() {
        return this.groupTotal.getExponentiationWindowSize();
    }

    public void setExponentiationWindowSize(int exponentiationWindowSize) {
        this.groupTotal.setExponentiationWindowSize(exponentiationWindowSize);
        this.groupNoExpMultiExp.setExponentiationWindowSize(exponentiationWindowSize);
    }

    public int getPrecomputationWindowSize() {
        return this.groupTotal.getPrecomputationWindowSize();
    }

    public void setPrecomputationWindowSize(int precomputationWindowSize) {
        this.groupTotal.setPrecomputationWindowSize(precomputationWindowSize);
        this.groupNoExpMultiExp.setPrecomputationWindowSize(precomputationWindowSize);
    }

    public MultiExpAlgorithm getSelectedMultiExpAlgorithm() {
        return this.groupTotal.getSelectedMultiExpAlgorithm();
    }

    public void setSelectedMultiExpAlgorithm(MultiExpAlgorithm selectedMultiExpAlgorithm) {
        this.groupTotal.setSelectedMultiExpAlgorithm(selectedMultiExpAlgorithm);
        this.groupNoExpMultiExp.setSelectedMultiExpAlgorithm(selectedMultiExpAlgorithm);
    }

    public ExpAlgorithm getSelectedExpAlgorithm() {
        return this.groupTotal.getSelectedExpAlgorithm();
    }

    public void setSelectedExpAlgorithm(ExpAlgorithm selectedExpAlgorithm) {
        this.groupTotal.setSelectedExpAlgorithm(selectedExpAlgorithm);
        this.groupNoExpMultiExp.setSelectedExpAlgorithm(selectedExpAlgorithm);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DebugGroup other = (DebugGroup)o;
        return Objects.equals(this.groupTotal, other.groupTotal) && Objects.equals(this.groupNoExpMultiExp, other.groupNoExpMultiExp);
    }

    public int hashCode() {
        return Objects.hash(this.groupTotal, this.groupNoExpMultiExp);
    }

    public String toString() {
        DebugGroupImpl debugImpl = (DebugGroupImpl)this.groupTotal.getImpl();
        return this.getClass().getSimpleName() + " with name " + debugImpl.name + " of size " + debugImpl.size();
    }
}

