/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.math.structures.groups.debug;

import java.math.BigInteger;
import java.util.Objects;
import org.cryptimeleon.math.hash.ByteAccumulator;
import org.cryptimeleon.math.serialization.ObjectRepresentation;
import org.cryptimeleon.math.serialization.Representation;
import org.cryptimeleon.math.structures.Element;
import org.cryptimeleon.math.structures.groups.Group;
import org.cryptimeleon.math.structures.groups.GroupElement;
import org.cryptimeleon.math.structures.groups.debug.DebugGroup;
import org.cryptimeleon.math.structures.groups.lazy.LazyGroup;
import org.cryptimeleon.math.structures.groups.lazy.LazyGroupElement;

public class DebugGroupElement
implements GroupElement {
    protected DebugGroup group;
    protected LazyGroupElement elemTotal;
    protected LazyGroupElement elemExpMultiExp;

    public DebugGroupElement(DebugGroup group, LazyGroupElement elemTotal, LazyGroupElement elemExpMultiExp) {
        this.group = group;
        this.elemTotal = elemTotal;
        this.elemExpMultiExp = elemExpMultiExp;
    }

    public DebugGroupElement(DebugGroup group, Representation repr) {
        ObjectRepresentation objRepr = repr.obj();
        this.group = group;
        this.elemTotal = (LazyGroupElement)group.groupTotal.restoreElement(objRepr.get("elemTotal"));
        this.elemExpMultiExp = (LazyGroupElement)group.groupNoExpMultiExp.restoreElement(objRepr.get("elemExpMultiExp"));
    }

    @Override
    public Representation getRepresentation() {
        ObjectRepresentation repr = new ObjectRepresentation();
        repr.put("elemTotal", this.elemTotal.getRepresentation());
        repr.put("elemExpMultiExp", this.elemExpMultiExp.getRepresentation());
        return repr;
    }

    @Override
    public Group getStructure() {
        return new DebugGroup((LazyGroup)this.elemTotal.getStructure(), (LazyGroup)this.elemExpMultiExp.getStructure());
    }

    @Override
    public GroupElement inv() {
        return new DebugGroupElement(this.group, (LazyGroupElement)this.elemTotal.inv(), (LazyGroupElement)this.elemExpMultiExp.inv());
    }

    @Override
    public GroupElement op(Element e) throws IllegalArgumentException {
        if (e == null) {
            throw new IllegalArgumentException("Argument element is null");
        }
        if (e.getClass() != this.getClass()) {
            throw new IllegalArgumentException("Argument element is not a CountingGroupElement");
        }
        DebugGroupElement other = (DebugGroupElement)e;
        return new DebugGroupElement(this.group, (LazyGroupElement)this.elemTotal.op(other.elemTotal), (LazyGroupElement)this.elemExpMultiExp.op(other.elemExpMultiExp));
    }

    @Override
    public GroupElement pow(BigInteger exponent) {
        return new DebugGroupElement(this.group, (LazyGroupElement)this.elemTotal.pow(exponent), (LazyGroupElement)this.elemExpMultiExp.pow(exponent));
    }

    @Override
    public GroupElement precomputePow() {
        return new DebugGroupElement(this.group, (LazyGroupElement)this.elemTotal.precomputePow(), (LazyGroupElement)this.elemExpMultiExp.precomputePow());
    }

    @Override
    public GroupElement precomputePow(int windowSize) {
        return new DebugGroupElement(this.group, (LazyGroupElement)this.elemTotal.precomputePow(windowSize), (LazyGroupElement)this.elemExpMultiExp.precomputePow(windowSize));
    }

    @Override
    public GroupElement compute() {
        return new DebugGroupElement(this.group, (LazyGroupElement)this.elemTotal.computeSync(), (LazyGroupElement)this.elemExpMultiExp.computeSync());
    }

    @Override
    public GroupElement computeSync() {
        return new DebugGroupElement(this.group, (LazyGroupElement)this.elemTotal.computeSync(), (LazyGroupElement)this.elemExpMultiExp.computeSync());
    }

    @Override
    public boolean isComputed() {
        return this.elemTotal.isComputed() && this.elemExpMultiExp.isComputed();
    }

    @Override
    public ByteAccumulator updateAccumulator(ByteAccumulator accumulator) {
        return this.elemExpMultiExp.updateAccumulator(this.elemTotal.updateAccumulator(accumulator));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DebugGroupElement other = (DebugGroupElement)o;
        return Objects.equals(this.group, other.group) && Objects.equals(this.elemTotal, other.elemTotal) && Objects.equals(this.elemExpMultiExp, other.elemExpMultiExp);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.group, this.elemTotal, this.elemExpMultiExp);
    }

    public String toString() {
        return this.group + " element " + this.elemTotal.computeSync().getRepresentation() + ";" + this.elemExpMultiExp.computeSync().getRepresentation();
    }
}

