/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.math.structures.groups.elliptic;

import org.cryptimeleon.math.serialization.ObjectRepresentation;
import org.cryptimeleon.math.serialization.Representation;
import org.cryptimeleon.math.structures.groups.elliptic.EllipticCurvePoint;
import org.cryptimeleon.math.structures.groups.elliptic.WeierstrassCurve;
import org.cryptimeleon.math.structures.rings.Field;
import org.cryptimeleon.math.structures.rings.FieldElement;

public abstract class AbstractEllipticCurvePoint
implements EllipticCurvePoint {
    FieldElement x;
    FieldElement y;
    FieldElement z;
    WeierstrassCurve structure;

    public AbstractEllipticCurvePoint(WeierstrassCurve curve, FieldElement x, FieldElement y, FieldElement z) {
        this.structure = curve;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public AbstractEllipticCurvePoint(WeierstrassCurve curve, Representation repr) {
        this(curve, curve.getFieldOfDefinition().restoreElement(repr.obj().get("x")), curve.getFieldOfDefinition().restoreElement(repr.obj().get("y")), curve.getFieldOfDefinition().restoreElement(repr.obj().get("z")));
    }

    @Override
    public Field getFieldOfDefinition() {
        return this.structure.getFieldOfDefinition();
    }

    public FieldElement getX() {
        return this.x;
    }

    public FieldElement getY() {
        return this.y;
    }

    public FieldElement getZ() {
        return this.z;
    }

    @Override
    public WeierstrassCurve getStructure() {
        return this.structure;
    }

    @Override
    public Representation getRepresentation() {
        AbstractEllipticCurvePoint normalized = (AbstractEllipticCurvePoint)this.normalize();
        ObjectRepresentation r = new ObjectRepresentation();
        r.put("x", normalized.getX().getRepresentation());
        r.put("y", normalized.getY().getRepresentation());
        r.put("z", normalized.getZ().getRepresentation());
        return r;
    }

    public String toString() {
        return this.isNeutralElement() ? "point at infinity" : (this.z.isOne() ? "(" + this.x.toString() + "," + this.y.toString() + ")" : "(" + this.x.toString() + "," + this.y.toString() + ", " + this.z.toString() + ")");
    }

    public int hashCode() {
        if (this.isNormalized()) {
            return this.getX().hashCode();
        }
        return ((AbstractEllipticCurvePoint)this.normalize()).getX().hashCode();
    }

    @Override
    public boolean isNeutralElement() {
        return this.z.isZero();
    }
}

