/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.math.structures.groups.elliptic.type1.supersingular;

import org.cryptimeleon.math.structures.groups.elliptic.AbstractPairing;
import org.cryptimeleon.math.structures.groups.elliptic.PairingSourceGroupElement;
import org.cryptimeleon.math.structures.groups.elliptic.type1.supersingular.SupersingularSourceGroupImpl;
import org.cryptimeleon.math.structures.groups.elliptic.type1.supersingular.SupersingularTargetGroupImpl;
import org.cryptimeleon.math.structures.rings.FieldElement;
import org.cryptimeleon.math.structures.rings.extfield.ExtensionField;
import org.cryptimeleon.math.structures.rings.extfield.ExtensionFieldElement;

class SupersingularTatePairing
extends AbstractPairing {
    public SupersingularTatePairing(SupersingularSourceGroupImpl g1, SupersingularTargetGroupImpl gT) {
        super(g1, g1, gT);
    }

    @Override
    protected ExtensionFieldElement evaluateLine(FieldElement[] line, PairingSourceGroupElement P, PairingSourceGroupElement Q) {
        ExtensionField targetField = this.gT.getFieldOfDefinition();
        if (!P.isNormalized() || !Q.isNormalized()) {
            throw new IllegalArgumentException("Currently, only affine points are supported.");
        }
        FieldElement xp = P.getX();
        FieldElement yp = P.getY();
        FieldElement xq = Q.getX();
        FieldElement yq = Q.getY();
        FieldElement t0 = line[1].mul(xq.add(xp)).sub(line[0].mul(yp));
        FieldElement t1 = line[0].mul(yq);
        return targetField.createElement(t0, t1);
    }

    @Override
    protected ExtensionFieldElement pair(PairingSourceGroupElement P, PairingSourceGroupElement Q) {
        if (P.isNeutralElement() || Q.isNeutralElement()) {
            return this.gT.getFieldOfDefinition().getOneElement();
        }
        ExtensionFieldElement result = this.miller(P, Q, this.g1.size());
        return result;
    }

    @Override
    public boolean isSymmetric() {
        return true;
    }
}

